/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.objectstore.config;

import org.mule.config.MuleManifest;
import org.mule.modules.objectstore.config.AllKeysDefinitionParser;
import org.mule.modules.objectstore.config.ContainsDefinitionParser;
import org.mule.modules.objectstore.config.DualStoreDefinitionParser;
import org.mule.modules.objectstore.config.ObjectStoreConnectorConfigConfigDefinitionParser;
import org.mule.modules.objectstore.config.RemoveDefinitionParser;
import org.mule.modules.objectstore.config.RetrieveDefinitionParser;
import org.mule.modules.objectstore.config.RetrieveStoreDefinitionParser;
import org.mule.modules.objectstore.config.RetrieveWithLockDefinitionParser;
import org.mule.modules.objectstore.config.StoreDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class ObjectstoreNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(ObjectstoreNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [objectstore] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [objectstore] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new ObjectStoreConnectorConfigConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("store", (BeanDefinitionParser)new StoreDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("store", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("dual-store", (BeanDefinitionParser)new DualStoreDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("dual-store", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("retrieve", (BeanDefinitionParser)new RetrieveDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("retrieve", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("retrieve-with-lock", (BeanDefinitionParser)new RetrieveWithLockDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("retrieve-with-lock", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("retrieve-store", (BeanDefinitionParser)new RetrieveStoreDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("retrieve-store", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("remove", (BeanDefinitionParser)new RemoveDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("remove", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("all-keys", (BeanDefinitionParser)new AllKeysDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("all-keys", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("contains", (BeanDefinitionParser)new ContainsDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("contains", "@Processor", ex);
        }
    }
}

