/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.objectstore.config;

import org.mule.config.MuleManifest;
import org.mule.modules.objectstore.Config;
import org.mule.modules.objectstore.adapters.ObjectStoreConnectorConfigBasicAdapter;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ObjectStoreConnectorConfigConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(ObjectStoreConnectorConfigConfigDefinitionParser.class);

    public String moduleName() {
        return "ObjectStore";
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, ObjectStoreConnectorConfigBasicAdapter.class);
        this.setDestroyMethodIfNeeded(builder, ObjectStoreConnectorConfigBasicAdapter.class);
        BeanDefinitionBuilder basicConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)Config.class.getName());
        this.parseProperty(basicConfigBuilder, element, "partition", "partition");
        this.parseProperty(basicConfigBuilder, element, "persistent", "persistent");
        if (this.hasAttribute(element, "objectStore-ref")) {
            if (element.getAttribute("objectStore-ref").startsWith("#")) {
                basicConfigBuilder.addPropertyValue("objectStore", (Object)element.getAttribute("objectStore-ref"));
            } else {
                basicConfigBuilder.addPropertyValue("objectStore", (Object)new RuntimeBeanReference(element.getAttribute("objectStore-ref")));
            }
        }
        this.parseProperty(basicConfigBuilder, element, "entryTtl", "entryTtl");
        this.parseProperty(basicConfigBuilder, element, "maxEntries", "maxEntries");
        this.parseProperty(basicConfigBuilder, element, "expirationInterval", "expirationInterval");
        builder.addPropertyValue("config", (Object)basicConfigBuilder.getBeanDefinition());
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        return definition;
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)ObjectStoreConnectorConfigBasicAdapter.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the configuration [config] within the connector [objectstore] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the configuration [config] within the connector [objectstore] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }
}

