/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.scheduler.internal.reporting;

import org.mule.runtime.api.alert.TimedDataBuffer;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.service.scheduler.ThreadType;

import java.util.concurrent.Executor;

/**
 * Specialization of {@link Scheduler} that allows some of its internal configuration and usage statistics to be queried.
 *
 * @since 4.10, 4.9.8, 4.6.21
 */
public interface ReportableScheduler extends Scheduler {

  /**
   * @return the underlying thread pool being used by this scheduler.
   */
  public Executor getActualExecutor();

  /**
   * @return the kind of tasks this scheduler is configured to run.
   */
  public ThreadType getThreadType();

  /**
   * The number of tasks waiting in a queue for this scheduler.
   * <p>
   * 0 may mean there is no queue, or it cannot be queried, or there are no queued items.
   *
   * @return the number of tasks waiting in a queue for this scheduler.
   */
  public int getQueuedTasks();

  /**
   * @return the number of tasks that are executing or awaiting execution in this scheduler.
   */
  public int getTasksCount();

  /**
   * @return how many tasks were rejected from this scheduler because it was a max capacity.
   */
  public TimedDataBuffer<String> getRejectionsOverTime();

  /**
   * @return how many tasks were throttled from this scheduler because it was a max capacity.
   */
  public TimedDataBuffer<String> getThrottlesOverTime();

}
