/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.service.scheduler.internal.AbstractRunnableFutureDecorator;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunnableFutureDecorator<V>
extends AbstractRunnableFutureDecorator<V> {
    private static final Logger logger = LoggerFactory.getLogger(RunnableFutureDecorator.class);
    private final RunnableFuture<V> task;
    private final DefaultScheduler scheduler;
    private final String taskAsString;

    RunnableFutureDecorator(RunnableFuture<V> task, ClassLoader classLoader, DefaultScheduler scheduler, String taskAsString, int id, ProfilingService profilingService) {
        super(id, classLoader, profilingService);
        this.task = task;
        this.scheduler = scheduler;
        this.taskAsString = taskAsString;
    }

    @Override
    public void run() {
        this.doRun(this.task);
    }

    @Override
    protected void wrapUp() throws Exception {
        this.scheduler.taskFinished(this);
        super.wrapUp();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.resetClassloader();
        logger.debug("Cancelling task {} (mayInterruptIfRunning={})...", (Object)this, (Object)mayInterruptIfRunning);
        boolean success = this.task.cancel(mayInterruptIfRunning);
        this.scheduler.taskFinished(this);
        return success;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.task.get(timeout, unit);
    }

    public String toString() {
        return this.getSchedulerName() + " - " + this.taskAsString;
    }

    @Override
    public String getSchedulerName() {
        return this.scheduler.getName();
    }

    @Override
    public String getThreadNameSuffix() {
        return this.scheduler.getThreadNameSuffix();
    }
}

