/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.service.scheduler.internal.SchedulerThreadPoolsTestCase;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.service.scheduler.internal.util.Delegator;

public class DedicatedSchedulerThreadPoolsTestCase
extends SchedulerThreadPoolsTestCase {
    public DedicatedSchedulerThreadPoolsTestCase() {
        this.strategy = SchedulerPoolStrategy.DEDICATED;
    }

    @Test
    @Description(value="Tests that IO threads in excess of the core size don't hold a reference to an artifact classloader through the inheritedAccessControlContext.")
    public void elasticIoThreadsDontReferenceClassLoaderFromAccessControlContext() throws Exception {
        MatcherAssert.assertThat((Object)this.threadPoolsConfig.getIoKeepAlive().getAsLong(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(10000L)));
        Scheduler scheduler = this.service.createIoScheduler(SchedulerConfig.config(), this.threadPoolsConfig.getIoCorePoolSize().getAsInt() + 1, () -> 1000L);
        ClassLoader delegatorClassLoader = this.createDelegatorClassLoader();
        PhantomReference<ClassLoader> clRef = new PhantomReference<ClassLoader>(delegatorClassLoader, new ReferenceQueue());
        Consumer delegator = (Consumer)delegatorClassLoader.loadClass(Delegator.class.getName()).newInstance();
        for (int i = 0; i < this.threadPoolsConfig.getIoCorePoolSize().getAsInt() + 1; ++i) {
            delegator.accept(() -> scheduler.execute(() -> {}));
        }
        delegator = null;
        delegatorClassLoader = null;
        this.assertNoClassLoaderReferenceHeld(clRef, 10000L);
    }

    @Test
    @Description(value="Tests that tasks dispatched from a CPU Light thread to a busy Scheduler are rejected.")
    public void rejectionPolicyCpuLight() throws MuleException, InterruptedException, ExecutionException, TimeoutException {
        Scheduler sourceScheduler = this.service.createCpuLightScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        Scheduler targetScheduler = this.service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1), CORES, () -> 1000L);
        Latch latch = new Latch();
        Future submit = sourceScheduler.submit(this.threadsConsumer(targetScheduler, latch));
        ExecutionException thrown = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> submit.get(60L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)IsInstanceOf.instanceOf(SchedulerBusyException.class));
    }

    @Test
    @Description(value="Tests that tasks dispatched from a CPU Intensive thread to a busy Scheduler are rejected.")
    public void rejectionPolicyCpuIntensive() throws MuleException, InterruptedException, ExecutionException, TimeoutException {
        Scheduler sourceScheduler = this.service.createCpuIntensiveScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        Scheduler targetScheduler = this.service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1), CORES, () -> 1000L);
        Latch latch = new Latch();
        Future submit = sourceScheduler.submit(this.threadsConsumer(targetScheduler, latch));
        ExecutionException thrown = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> submit.get(60L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)IsInstanceOf.instanceOf(SchedulerBusyException.class));
    }

    @Test
    @Description(value="Tests that when the IO pool is full, any task dispatched from IO to IO runs in the caller thread instead of being queued, which can cause a deadlock.")
    public void ioToFullIoDoesntWait() throws InterruptedException, ExecutionException {
        Scheduler ioScheduler = this.service.createIoScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        Latch outerLatch = new Latch();
        Latch innerLatch = new Latch();
        for (int i = 0; i < this.threadPoolsConfig.getIoMaxPoolSize().getAsInt() - 1; ++i) {
            this.consumeThread(ioScheduler, outerLatch);
        }
        AtomicReference callerThread = new AtomicReference();
        AtomicReference executingThread = new AtomicReference();
        Future submitted = ioScheduler.submit(() -> {
            callerThread.set(Thread.currentThread());
            ioScheduler.submit(() -> {
                executingThread.set(Thread.currentThread());
                innerLatch.countDown();
            });
            return this.awaitLatch(outerLatch);
        });
        MatcherAssert.assertThat((Object)innerLatch.await(5L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        outerLatch.countDown();
        MatcherAssert.assertThat((Object)((Boolean)submitted.get()), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((Thread)executingThread.get()), (Matcher)Is.is((Object)((Thread)callerThread.get())));
    }

    @Test
    @Description(value="Tests that when the IO pool is full, any task dispatched from a CUSTOM pool with WAIT rejection action to IO is queued.")
    public void customWaitToFullIoWaits() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler customScheduler = this.service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withWaitAllowed(true), CORES, () -> 1000L);
        Scheduler ioScheduler = this.service.createIoScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        Latch latch = new Latch();
        for (int i = 0; i < this.threadPoolsConfig.getIoMaxPoolSize().getAsInt(); ++i) {
            this.consumeThread(ioScheduler, latch);
        }
        Future submitted = customScheduler.submit(() -> {
            ioScheduler.submit(() -> {});
            Assert.fail((String)"Didn't wait");
            return null;
        });
        Assert.assertThrows(TimeoutException.class, () -> submitted.get(5L, TimeUnit.SECONDS));
        latch.countDown();
        ioScheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Tests that when the CPU-lite pool is full, any task dispatched from a CUSTOM pool with DirectRunToFullCpuLight falg to CPU-lite is run directlyi in the caller thread.")
    public void customDirectRunToFullCpuLight() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler customScheduler = this.service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withDirectRunCpuLightWhenTargetBusy(true), CORES, () -> 1000L);
        Scheduler cpuLightScheduler = this.service.createCpuLightScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        Latch latch = new Latch();
        for (int i = 0; i < this.threadPoolsConfig.getCpuLightPoolSize().getAsInt() + this.threadPoolsConfig.getCpuLightQueueSize().getAsInt(); ++i) {
            this.consumeThread(cpuLightScheduler, latch);
        }
        AtomicReference callerThread = new AtomicReference();
        AtomicReference taskRunThread = new AtomicReference();
        Future submitted = customScheduler.submit(() -> {
            callerThread.set(Thread.currentThread());
            cpuLightScheduler.submit(() -> taskRunThread.set(Thread.currentThread()));
            return null;
        });
        try {
            submitted.get(5L, TimeUnit.SECONDS);
        }
        finally {
            latch.countDown();
        }
        MatcherAssert.assertThat((Object)((Thread)taskRunThread.get()), (Matcher)CoreMatchers.sameInstance((Object)((Thread)callerThread.get())));
    }

    @Test
    @Description(value="Tests that the behavior of combining runCpuLightWhenTargetBusy and waitAllowed depends on the target thread.")
    public void customWaitToFullIoWaitsAndWaitToFullIoWaits() throws InterruptedException, ExecutionException, TimeoutException {
        int i;
        Scheduler customScheduler = this.service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withWaitAllowed(true).withDirectRunCpuLightWhenTargetBusy(true), CORES, () -> 1000L);
        Scheduler ioScheduler = this.service.createIoScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        Scheduler cpuLightScheduler = this.service.createCpuLightScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        Latch latch = new Latch();
        for (i = 0; i < this.threadPoolsConfig.getIoMaxPoolSize().getAsInt(); ++i) {
            this.consumeThread(ioScheduler, latch);
        }
        for (i = 0; i < this.threadPoolsConfig.getCpuLightPoolSize().getAsInt() + this.threadPoolsConfig.getCpuLightQueueSize().getAsInt(); ++i) {
            this.consumeThread(cpuLightScheduler, latch);
        }
        AtomicReference callerThread = new AtomicReference();
        AtomicReference taskRunThread = new AtomicReference();
        Future submittedCpuLight = customScheduler.submit(() -> {
            callerThread.set(Thread.currentThread());
            cpuLightScheduler.submit(() -> taskRunThread.set(Thread.currentThread()));
            return null;
        });
        Future submittedIo = customScheduler.submit(() -> {
            ioScheduler.submit(() -> {});
            Assert.fail((String)"Didn't wait");
            return null;
        });
        submittedCpuLight.get(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)((Thread)taskRunThread.get()), (Matcher)CoreMatchers.sameInstance((Object)((Thread)callerThread.get())));
        Assert.assertThrows(TimeoutException.class, () -> submittedIo.get(5L, TimeUnit.SECONDS));
        latch.countDown();
    }

    @Test
    @Description(value="Tests that ThrottledScheduler is not used for CPU light schedulers unless maxConcurrency is less than backing pool max size.")
    public void maxCpuLightConcurrencyMoreThanMaxPoolSizeDoesntUseThrottlingScheduler() {
        MatcherAssert.assertThat((Object)this.service.createCpuLightScheduler(SchedulerConfig.config().withMaxConcurrentTasks(this.threadPoolsConfig.getCpuLightPoolSize().getAsInt()), 1, () -> 1L), (Matcher)CoreMatchers.not((Matcher)IsInstanceOf.instanceOf(ThrottledScheduler.class)));
        MatcherAssert.assertThat((Object)this.service.createCpuLightScheduler(SchedulerConfig.config().withMaxConcurrentTasks(this.threadPoolsConfig.getCpuLightPoolSize().getAsInt() - 1), 1, () -> 1L), (Matcher)IsInstanceOf.instanceOf(ThrottledScheduler.class));
    }

    @Test
    @Description(value="Tests that ThrottledScheduler is not used for CPU intensive schedulers unless maxConcurrency is less than backing pool max size.")
    public void maxCpuIntensiveConcurrencyMoreThanMaxPoolSizeDoesntUseThrottlingScheduler() {
        MatcherAssert.assertThat((Object)this.service.createCpuIntensiveScheduler(SchedulerConfig.config().withMaxConcurrentTasks(this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt()), 1, () -> 1L), (Matcher)CoreMatchers.not((Matcher)IsInstanceOf.instanceOf(ThrottledScheduler.class)));
        MatcherAssert.assertThat((Object)this.service.createCpuIntensiveScheduler(SchedulerConfig.config().withMaxConcurrentTasks(this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt() - 1), 1, () -> 1L), (Matcher)IsInstanceOf.instanceOf(ThrottledScheduler.class));
    }

    @Test
    @Description(value="Tests that ThrottledScheduler is not used for IO schedulers unless maxConcurrency is less than backing pool max size.")
    public void maxIOConcurrencyMoreThanMaxPoolSizeDoesntUseThrottlingScheduler() {
        MatcherAssert.assertThat((Object)this.service.createIoScheduler(SchedulerConfig.config().withMaxConcurrentTasks(this.threadPoolsConfig.getIoMaxPoolSize().getAsInt()), 1, () -> 1L), (Matcher)CoreMatchers.not((Matcher)IsInstanceOf.instanceOf(ThrottledScheduler.class)));
        MatcherAssert.assertThat((Object)this.service.createIoScheduler(SchedulerConfig.config().withMaxConcurrentTasks(this.threadPoolsConfig.getIoMaxPoolSize().getAsInt() - 1), 1, () -> 1L), (Matcher)IsInstanceOf.instanceOf(ThrottledScheduler.class));
    }
}

