/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.util.concurrent.Latch;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class CronSchedulerHandler {
    private static final int WAIT_TIMEOUT = 5000;
    private final ThreadGroup threadGroup;
    private final String threadNamePrefix;
    private final Latch latch = new Latch();
    private volatile Throwable exception = null;
    private volatile Scheduler quartzScheduler = null;
    private final Runnable schedulerCreator = () -> {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            schedulerFactory.initialize(this.defaultQuartzProperties());
            this.quartzScheduler = schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            this.exception = e;
        }
        finally {
            this.latch.release();
        }
    };

    public CronSchedulerHandler(ThreadGroup threadGroup, String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Scheduler getScheduler() throws SchedulerException, InterruptedException {
        if (this.quartzScheduler != null) return this.quartzScheduler;
        Class<CronSchedulerHandler> clazz = CronSchedulerHandler.class;
        synchronized (CronSchedulerHandler.class) {
            if (this.quartzScheduler != null) return this.quartzScheduler;
            new Thread(this.threadGroup, this.schedulerCreator, "CronSchedulerHandler").start();
            if (!this.latch.await(5000L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Quartz scheduler creation timed out");
            }
            if (this.exception == null) return this.quartzScheduler;
            throw (SchedulerException)this.exception;
        }
    }

    private Properties defaultQuartzProperties() {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty("org.quartz.scheduler.instanceName", this.threadNamePrefix);
        factoryProperties.setProperty("org.quartz.threadPool.threadsInheritGroupOfInitializingThread", "true");
        factoryProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        factoryProperties.setProperty("org.quartz.threadPool.threadNamePrefix", this.threadNamePrefix + "_qz");
        factoryProperties.setProperty("org.quartz.threadPool.threadCount", "1");
        factoryProperties.setProperty("org.quartz.jobStore.misfireThreshold", "" + TimeUnit.SECONDS.toMillis(5L));
        return factoryProperties;
    }
}

