/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.concurrent.ExecutionException;
import org.junit.Test;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.service.scheduler.internal.SchedulerThreadPoolsTestCase;

public class UberSchedulerThreadPoolsTestCase
extends SchedulerThreadPoolsTestCase {
    public UberSchedulerThreadPoolsTestCase() {
        this.strategy = SchedulerPoolStrategy.UBER;
    }

    @Test
    @Issue(value="MULE-20072")
    @Description(value="Tests that when a rejected task submitted from a CPU Intensive pool is executed on the caller thread, the thread locals of the task are isolated from the caller's.")
    public void cpuIntensiveCallerRunsHasThreadLocalsIsolation() throws ExecutionException, InterruptedException {
        Scheduler scheduler = this.service.createCpuIntensiveScheduler(SchedulerConfig.config(), CORES, () -> 1000L);
        int maxPoolSize = this.threadPoolsConfig.getUberMaxPoolSize().getAsInt();
        this.assertCallerRunsThreadLocalsIsolation(scheduler, maxPoolSize);
    }
}

