/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.SchedulerBusyException;

public class WaitPolicy
implements RejectedExecutionHandler {
    private final long time;
    private final TimeUnit timeUnit;
    private final RejectedExecutionHandler shutdownPolicy;
    private final String schedulerName;

    public WaitPolicy(RejectedExecutionHandler shutdownPolicy, String schedulerName) {
        this(Long.MAX_VALUE, TimeUnit.SECONDS, shutdownPolicy, schedulerName);
    }

    public WaitPolicy(long time, TimeUnit timeUnit, RejectedExecutionHandler shutdownPolicy, String schedulerName) {
        this.time = time < 0L ? Long.MAX_VALUE : time;
        this.timeUnit = timeUnit;
        this.shutdownPolicy = shutdownPolicy;
        this.schedulerName = schedulerName;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        if (e.isShutdown()) {
            this.shutdownPolicy.rejectedExecution(r, e);
        } else {
            try {
                if (!e.getQueue().offer(r, this.time, this.timeUnit)) {
                    throw new SchedulerBusyException(String.format("Scheduler '%s' did not accept within %1d %2s", new Object[]{this.schedulerName, this.time, this.timeUnit}));
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException(ie);
            }
        }
    }
}

