/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@RunWith(value=Parameterized.class)
@Feature(value="Scheduler Service")
@Story(value="Termination")
public class DefaultSchedulerTerminationTestCase
extends BaseDefaultSchedulerTestCase {
    private static final long STOP_DELAY_DELTA = 100L;
    private Matcher<ExecutorService> terminatedMatcher;

    public DefaultSchedulerTerminationTestCase(Matcher<ExecutorService> terminatedMatcher) {
        this.terminatedMatcher = terminatedMatcher;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({DefaultSchedulerTerminationTestCase.isTerminated()}, {DefaultSchedulerTerminationTestCase.isTerminatedAfterAwait()});
    }

    @Test
    @io.qameta.allure.Description(value="Tests that the Scheduler is properly terminated after calling shutdown()")
    public void terminatedAfterShutdownSameExecutor() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor = this.createExecutor();
        executor.shutdown();
        Assert.assertThat((Object)executor, this.terminatedMatcher);
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdown() in a Scheduler has no impact on another Scheduler backed by the same Executor")
    public void terminatedAfterShutdownOtherExecutor() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor1 = this.createExecutor();
        ScheduledExecutorService executor2 = this.createExecutor();
        executor1.shutdown();
        Assert.assertThat((Object)executor1, this.terminatedMatcher);
        Assert.assertThat((Object)executor2, (Matcher)CoreMatchers.not(this.terminatedMatcher));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that the Scheduler is properly terminated after calling shutdownNow()")
    public void terminatedAfterShutdownNowSameExecutor() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor = this.createExecutor();
        executor.shutdownNow();
        Assert.assertThat((Object)executor, this.terminatedMatcher);
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdownNow() in a Scheduler has no impact on another Scheduler backed by the same Executor")
    public void terminatedAfterShutdownNowOtherExecutor() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor1 = this.createExecutor();
        ScheduledExecutorService executor2 = this.createExecutor();
        executor1.shutdownNow();
        Assert.assertThat((Object)executor1, DefaultSchedulerTerminationTestCase.isTerminated());
        Assert.assertThat((Object)executor2, (Matcher)CoreMatchers.not(this.terminatedMatcher));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdown() on a Scheduler while it's running a task waits for it to finish before terminating")
    public void terminatedAfterShutdownRunningTask() throws InterruptedException, ExecutionException, TimeoutException {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        Future<Boolean> result = executor.submit(() -> this.awaitLatch(latch));
        executor.shutdown();
        Assert.assertThat((Object)executor, (Matcher)CoreMatchers.not(this.terminatedMatcher));
        latch.countDown();
        result.get(1L, TimeUnit.SECONDS);
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdownNow() on a Scheduler terminates it even if it's running a submitted task")
    public void terminatedAfterShutdownNowRunningSubmittedTask() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        executor.submit(() -> this.awaitLatch(latch));
        executor.shutdownNow();
        Assert.assertThat((Object)executor, this.terminatedMatcher);
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdownNow() on a Scheduler terminates it even if it's running a task")
    public void terminatedAfterShutdownNowRunningTask() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(() -> this.awaitLatch(latch));
        executor.shutdownNow();
        Assert.assertThat((Object)executor, this.terminatedMatcher);
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdown() on a Scheduler with a queued task runs that task before terminating")
    public void terminatedAfterShutdownPendingTask() throws InterruptedException, ExecutionException, TimeoutException {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        Future<Boolean> result = executor.submit(() -> this.awaitLatch(latch1));
        Future<Boolean> pendingResult = executor.submit(() -> this.awaitLatch(latch2));
        executor.shutdown();
        Assert.assertThat((Object)executor, (Matcher)CoreMatchers.not(this.terminatedMatcher));
        latch1.countDown();
        Assert.assertThat((Object)result.get(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)executor, (Matcher)CoreMatchers.not(this.terminatedMatcher));
        latch2.countDown();
        Assert.assertThat((Object)pendingResult.get(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdown() on a Scheduler with a fixed-delay Callable in-between executions frees the timer executor")
    public void terminatedAfterShutdownInBetweenFixedDelayTask() throws InterruptedException, ExecutionException, TimeoutException {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> result = executor.scheduleWithFixedDelay(() -> latch.countDown(), 0L, 10L, TimeUnit.SECONDS);
        latch.await();
        result.cancel(false);
        this.assertTerminationIsNotDelayed(this.sharedScheduledExecutor);
        executor.shutdown();
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdownNow() on a Scheduler with a queued submitted task doesn't wait for that task to run before terminating")
    public void terminatedAfterShutdownNowPendingSubmittedTask() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        executor.submit(() -> this.awaitLatch(latch));
        executor.submit(() -> this.awaitLatch(latch));
        executor.shutdownNow();
        Assert.assertThat((Object)executor, this.terminatedMatcher);
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling shutdownNow() on a Scheduler with a queued task doesn't wait for that task to run before terminating")
    public void terminatedAfterShutdownNowPendingTask() throws InterruptedException, ExecutionException {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(() -> this.awaitLatch(latch));
        executor.execute(() -> this.awaitLatch(latch));
        executor.shutdownNow();
        Assert.assertThat((Object)executor, this.terminatedMatcher);
    }

    @Test
    @io.qameta.allure.Description(value="Tests that the Scheduler is gracefully terminated after calling stop()")
    public void terminatedAfterStopGracefully() throws InterruptedException, ExecutionException {
        Scheduler executor = (Scheduler)this.createExecutor();
        this.sharedExecutor.submit(() -> executor.stop());
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler while it's running a submitted task waits for it to finish before terminating gracefully")
    public void terminatedAfterStopGracefullyRunningSubmittedTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        executor.submit(() -> {
            latch1.countDown();
            return this.awaitLatch(latch2);
        });
        latch1.await(60L, TimeUnit.SECONDS);
        ExecutorService auxExecutor = Executors.newSingleThreadExecutor();
        try {
            auxExecutor.submit(() -> executor.stop());
            latch2.countDown();
            this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)executor, this.terminatedMatcher);
                return true;
            }));
        }
        finally {
            auxExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler while it's running a task waits for it to finish before terminating gracefully")
    public void terminatedAfterStopGracefullyRunningTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        executor.execute(() -> {
            latch1.countDown();
            this.awaitLatch(latch2);
        });
        latch1.await(60L, TimeUnit.SECONDS);
        ExecutorService auxExecutor = Executors.newSingleThreadExecutor();
        try {
            auxExecutor.submit(() -> executor.stop());
            latch2.countDown();
            this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)executor, this.terminatedMatcher);
                return true;
            }));
        }
        finally {
            auxExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler with a queued submitted task runs that task before terminating gracefully")
    public void terminatedAfterStopGracefullyPendingSubmittedTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        executor.submit(() -> this.awaitLatch(latch1));
        executor.submit(() -> this.awaitLatch(latch2));
        ExecutorService auxExecutor = Executors.newSingleThreadExecutor();
        try {
            auxExecutor.submit(() -> executor.stop());
            latch1.countDown();
            latch2.countDown();
            this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)executor, this.terminatedMatcher);
                return true;
            }));
        }
        finally {
            auxExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler with a queued task runs that task before terminating gracefully")
    public void terminatedAfterStopGracefullyPendingTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        executor.execute(() -> this.awaitLatch(latch1));
        executor.execute(() -> this.awaitLatch(latch2));
        ExecutorService auxExecutor = Executors.newSingleThreadExecutor();
        try {
            auxExecutor.submit(() -> executor.stop());
            latch1.countDown();
            latch2.countDown();
            this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)executor, this.terminatedMatcher);
                return true;
            }));
        }
        finally {
            auxExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler after running a submitted task terminates gracefullyand immediately")
    public void terminatedAfterStopGracefullyFinishedSubmittedTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        executor.submit(() -> true);
        ExecutorService auxExecutor = Executors.newSingleThreadExecutor();
        try {
            long stopReqNanos = System.nanoTime();
            auxExecutor.submit(() -> executor.stop());
            this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)executor, this.terminatedMatcher);
                return true;
            }));
            Assert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopReqNanos), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(100L)));
        }
        finally {
            auxExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler after running a task terminates gracefullyand immediately")
    public void terminatedAfterStopGracefullyFinishedTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        executor.execute(() -> {});
        ExecutorService auxExecutor = Executors.newSingleThreadExecutor();
        try {
            long stopReqNanos = System.nanoTime();
            auxExecutor.submit(() -> executor.stop());
            this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
                Assert.assertThat((Object)executor, this.terminatedMatcher);
                return true;
            }));
            Assert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopReqNanos), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(100L)));
        }
        finally {
            auxExecutor.shutdown();
        }
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler while it's running a submitted task forcefully terminates it")
    public void terminatedAfterStopForcefullyRunningSubmittedTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        AtomicReference taskThread = new AtomicReference();
        executor.submit(() -> {
            latch1.countDown();
            try {
                Boolean bl = this.awaitLatch(latch2);
                return bl;
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    taskThread.set(Thread.currentThread());
                }
            }
        });
        latch1.await(60L, TimeUnit.SECONDS);
        executor.stop();
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)((Thread)taskThread.get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler while it's running a task forcefully terminates it")
    public void terminatedAfterStopForcefullyRunningTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        AtomicReference taskThread = new AtomicReference();
        executor.execute(() -> {
            latch1.countDown();
            try {
                this.awaitLatch(latch2);
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    taskThread.set(Thread.currentThread());
                }
            }
        });
        latch1.await(60L, TimeUnit.SECONDS);
        executor.stop();
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)((Thread)taskThread.get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler while it's running 2 tasks forcefully terminates them")
    public void terminatedAfterStopForcefullyRunningTasks() throws InterruptedException, ExecutionException, TimeoutException {
        this.sharedExecutor.shutdownNow();
        this.sharedExecutor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)this.sharedExecutorQueue, Executors.defaultThreadFactory());
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch1 = new CountDownLatch(5);
        CountDownLatch latch2 = new CountDownLatch(1);
        AtomicInteger interruptedThreads = new AtomicInteger();
        for (int i = 0; i < 5; ++i) {
            executor.execute(() -> {
                latch1.countDown();
                try {
                    this.awaitLatch(latch2);
                }
                finally {
                    if (Thread.currentThread().isInterrupted()) {
                        interruptedThreads.incrementAndGet();
                    }
                }
            });
        }
        latch1.await(60L, TimeUnit.SECONDS);
        executor.stop();
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)interruptedThreads.get(), (Matcher)CoreMatchers.is((Object)5));
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler with a queued submitted task forcefully terminates it")
    public void terminatedAfterStopForcefullyPendingSubmittedTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch finallyLatch = new CountDownLatch(2);
        AtomicReference taskThread = new AtomicReference();
        AtomicReference pendingTaskThread = new AtomicReference();
        executor.submit(() -> {
            try {
                Boolean bl = this.awaitLatch(latch);
                return bl;
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    taskThread.set(Thread.currentThread());
                }
                finallyLatch.countDown();
            }
        });
        executor.submit(() -> {
            try {
                Boolean bl = this.awaitLatch(latch);
                return bl;
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    pendingTaskThread.set(Thread.currentThread());
                }
                finallyLatch.countDown();
            }
        });
        executor.stop();
        finallyLatch.await(2L, TimeUnit.SECONDS);
        Assert.assertThat((Object)((Thread)taskThread.get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)((Thread)pendingTaskThread.get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    @Test
    @io.qameta.allure.Description(value="Tests that calling stop() on a Scheduler with a queued task forcefully terminates it")
    public void terminatedAfterStopForcefullyPendingTask() throws InterruptedException, ExecutionException, TimeoutException {
        Scheduler executor = (Scheduler)this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference taskThread = new AtomicReference();
        AtomicReference pendingTaskThread = new AtomicReference();
        executor.execute(() -> {
            try {
                this.awaitLatch(latch);
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    taskThread.set(Thread.currentThread());
                }
            }
        });
        executor.execute(() -> {
            try {
                this.awaitLatch(latch);
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    pendingTaskThread.set(Thread.currentThread());
                }
            }
        });
        executor.stop();
        this.terminationProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)((Thread)taskThread.get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
            Assert.assertThat((Object)((Thread)pendingTaskThread.get()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            Assert.assertThat((Object)executor, this.terminatedMatcher);
            return true;
        }));
    }

    private PollingProber terminationProber() {
        return new PollingProber(500L, 50L);
    }

    private static Matcher<ExecutorService> isTerminated() {
        return new TypeSafeMatcher<ExecutorService>(){
            private String itemString;

            protected boolean matchesSafely(ExecutorService item) {
                this.itemString = item.toString();
                return item.isTerminated();
            }

            public void describeTo(Description description) {
                description.appendValue((Object)this.itemString);
            }
        };
    }

    private static Matcher<ExecutorService> isTerminatedAfterAwait() {
        return new TypeSafeMatcher<ExecutorService>(){
            private String itemString;

            protected boolean matchesSafely(ExecutorService item) {
                this.itemString = item.toString();
                try {
                    return item.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendValue((Object)this.itemString);
            }
        };
    }
}

