/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;

@Feature(value="Scheduler Service")
@Story(value="Task Scheduling")
@RunWith(value=Parameterized.class)
public class DefaultSchedulerFixedDelayRepeatsTestCase
extends BaseDefaultSchedulerTestCase {
    private static final long TASK_DURATION_MILLIS = 200L;
    private static final long TEST_DELAY_MILLIS = 1000L;
    protected ScheduledExecutorService executor;

    public DefaultSchedulerFixedDelayRepeatsTestCase(BlockingQueue<Runnable> sharedExecutorQueue, String param) {
        this.sharedExecutorQueue = sharedExecutorQueue;
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new SynchronousQueue(), "syncQueue"}, {new LinkedBlockingQueue(1), "queue(1)"});
    }

    @Override
    public void before() throws Exception {
        super.before();
        this.executor = this.createExecutor();
    }

    @Override
    public void after() throws Exception {
        this.executor.shutdownNow();
        this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        super.after();
    }

    @Test
    @Description(value="Tests that scheduleAtFixedDelay parameters are honored")
    public void fixedDelayRepeats() {
        ArrayList startTimes = new ArrayList();
        ArrayList endTimes = new ArrayList();
        CountDownLatch latch = new CountDownLatch(2);
        ScheduledFuture<?> scheduled = this.executor.scheduleWithFixedDelay(() -> {
            startTimes.add(System.nanoTime());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            latch.countDown();
            endTimes.add(System.nanoTime());
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)this.awaitLatch(latch), (Matcher)CoreMatchers.is((Object)true));
        scheduled.cancel(true);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.sharedScheduledExecutor});
        ((ScheduledThreadPoolExecutor)inOrder.verify((Object)this.sharedScheduledExecutor)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)0L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledThreadPoolExecutor)inOrder.verify((Object)this.sharedScheduledExecutor)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.eq((long)1000L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        Assert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis((Long)startTimes.get(1) - (Long)endTimes.get(0)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(900L)));
    }
}

