/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.IsCloseTo;
import org.junit.After;
import org.junit.Before;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.tracing.TracingService;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TaskSchedulingProfilingEventContext;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class BaseDefaultSchedulerTestCase
extends AbstractMuleTestCase {
    protected static final int DELTA_MILLIS = 100;
    protected static final int EXECUTOR_TIMEOUT_SECS = 1;
    protected static final Runnable EMPTY_RUNNABLE = () -> {};
    protected static final Consumer<ScheduledExecutorService> SUBMIT_EMPTY_CALLABLE = exec -> exec.submit(() -> 0);
    protected static final Consumer<ScheduledExecutorService> SUBMIT_EMPTY_RUNNABLE = exec -> exec.submit(EMPTY_RUNNABLE);
    protected static final Consumer<ScheduledExecutorService> SUBMIT_RESULT_RUNNABLE = exec -> exec.submit(EMPTY_RUNNABLE, 0);
    protected static final Consumer<ScheduledExecutorService> EXECUTE_EMPTY_RUNNABLE = exec -> exec.execute(EMPTY_RUNNABLE);
    protected static final Consumer<org.mule.runtime.api.scheduler.Scheduler> EMPTY_SHUTDOWN_CALLBACK = scheduler -> {};
    protected boolean isProfilingServiceEnabled = false;
    protected BlockingQueue<Runnable> sharedExecutorQueue = new ArrayBlockingQueue<Runnable>(1);
    protected ExecutorService sharedExecutor;
    protected ScheduledThreadPoolExecutor sharedScheduledExecutor;
    protected Scheduler sharedQuartzScheduler;
    protected final ProfilingService profilingService = (ProfilingService)Mockito.mock(ProfilingService.class, (Answer)Answers.RETURNS_MOCKS);
    private final TracingService tracingService = (TracingService)Mockito.mock(TracingService.class);
    protected final ProfilingDataProducer<TaskSchedulingProfilingEventContext, Object> schedulingTaskDataProducer = (ProfilingDataProducer)Mockito.mock(ProfilingDataProducer.class);
    protected final ProfilingDataProducer<TaskSchedulingProfilingEventContext, Object> executingTaskDataProducer = (ProfilingDataProducer)Mockito.mock(ProfilingDataProducer.class);
    protected final ProfilingDataProducer<TaskSchedulingProfilingEventContext, Object> executedTaskDataProducer = (ProfilingDataProducer)Mockito.mock(ProfilingDataProducer.class);

    @Before
    @BeforeEach
    public void before() throws Exception {
        this.initializeProfilingMocks();
        this.sharedExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.sharedExecutorQueue, Executors.defaultThreadFactory());
        this.sharedScheduledExecutor = (ScheduledThreadPoolExecutor)Mockito.spy((Object)new ScheduledThreadPoolExecutor(1, Executors.defaultThreadFactory()));
        this.sharedScheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.sharedScheduledExecutor.setRemoveOnCancelPolicy(true);
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        schedulerFactory.initialize(this.defaultQuartzProperties());
        this.sharedQuartzScheduler = (Scheduler)Mockito.spy((Object)schedulerFactory.getScheduler());
        this.sharedQuartzScheduler.start();
    }

    @After
    @AfterEach
    public void after() throws Exception {
        this.sharedScheduledExecutor.shutdownNow();
        this.sharedQuartzScheduler.shutdown(true);
        this.sharedExecutor.shutdownNow();
        this.sharedScheduledExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        this.sharedExecutor.awaitTermination(5L, TimeUnit.SECONDS);
    }

    protected void assertTerminationIsNotDelayed(ScheduledExecutorService executor) throws InterruptedException {
        long startTime = System.nanoTime();
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), (Matcher)IsCloseTo.closeTo((double)0.0, (double)100.0));
    }

    protected ScheduledExecutorService createExecutor() {
        return new DefaultScheduler(BaseDefaultSchedulerTestCase.class.getSimpleName(), this.sharedExecutor, 1, (ScheduledExecutorService)this.sharedScheduledExecutor, this.sharedQuartzScheduler, ThreadType.CUSTOM, () -> 5000L, EMPTY_SHUTDOWN_CALLBACK, this.isProfilingServiceEnabled ? this.profilingService : null);
    }

    protected boolean awaitLatch(CountDownLatch latch) {
        try {
            return latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void initializeProfilingMocks() {
        Mockito.when((Object)this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.SCHEDULING_TASK_EXECUTION)).thenReturn(this.schedulingTaskDataProducer);
        Mockito.when((Object)this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.STARTING_TASK_EXECUTION)).thenReturn(this.executingTaskDataProducer);
        Mockito.when((Object)this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.STARTING_TASK_EXECUTION)).thenReturn(this.executingTaskDataProducer);
        Mockito.when((Object)this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TASK_EXECUTED)).thenReturn(this.executedTaskDataProducer);
        Mockito.when((Object)this.profilingService.getTracingService()).thenReturn((Object)this.tracingService);
    }

    private Properties defaultQuartzProperties() {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty("org.quartz.scheduler.instanceName", ((Object)((Object)this)).getClass().getSimpleName());
        factoryProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        factoryProperties.setProperty("org.quartz.threadPool.threadNamePrefix", ((Object)((Object)this)).getClass().getSimpleName() + "_qz");
        factoryProperties.setProperty("org.quartz.threadPool.threadCount", "1");
        return factoryProperties;
    }
}

