/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.reporting;

import io.qameta.allure.Feature;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mule.runtime.api.alert.TimedDataBuffer;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.reporting.DefaultSchedulerView;
import org.mule.service.scheduler.internal.reporting.ReportableScheduler;

@Feature(value="Scheduler Service")
@ExtendWith(value={MockitoExtension.class})
class DefaultSchedulerViewTestCase {
    @Mock
    private ReportableScheduler scheduler;
    private DefaultSchedulerView schedulerView;

    DefaultSchedulerViewTestCase() {
    }

    @BeforeEach
    public void setUp() {
        this.schedulerView = new DefaultSchedulerView(this.scheduler);
    }

    @Test
    void getName() {
        Mockito.when((Object)this.scheduler.getName()).thenReturn((Object)"someScheduler");
        MatcherAssert.assertThat((Object)this.schedulerView.getName(), (Matcher)Is.is((Object)"someScheduler"));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).getName();
    }

    @Test
    void isShutdown() {
        Mockito.when((Object)this.scheduler.isShutdown()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.schedulerView.isShutdown(), (Matcher)Is.is((Object)true));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).isShutdown();
    }

    @Test
    void isTerminated() {
        Mockito.when((Object)this.scheduler.isTerminated()).thenReturn((Object)true);
        MatcherAssert.assertThat((Object)this.schedulerView.isTerminated(), (Matcher)Is.is((Object)true));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).isTerminated();
    }

    @Test
    void getThreadType() {
        Mockito.when((Object)this.scheduler.getThreadType()).thenReturn((Object)ThreadType.IO);
        MatcherAssert.assertThat((Object)this.schedulerView.getThreadType(), (Matcher)Is.is((Object)"IO"));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).getThreadType();
    }

    @Test
    void getQueuedTasks() {
        Mockito.when((Object)this.scheduler.getQueuedTasks()).thenReturn((Object)4);
        MatcherAssert.assertThat((Object)this.schedulerView.getQueuedTasks(), (Matcher)Is.is((Object)4));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).getQueuedTasks();
    }

    @Test
    void getActiveTasks() {
        Mockito.when((Object)this.scheduler.getQueuedTasks()).thenReturn((Object)4);
        Mockito.when((Object)this.scheduler.getTasksCount()).thenReturn((Object)6);
        MatcherAssert.assertThat((Object)this.schedulerView.getActiveTasks(), (Matcher)Is.is((Object)2));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).getTasksCount();
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).getQueuedTasks();
    }

    @Test
    void getRejectionsOverTime() {
        TimedDataBuffer rejections = new TimedDataBuffer();
        rejections.put((Object)"a");
        Mockito.when((Object)this.scheduler.getRejectionsOverTime()).thenReturn((Object)rejections);
        MatcherAssert.assertThat((Object)((Integer)this.schedulerView.getRejectionsOverTime().forLast60MinsInterval()), (Matcher)Is.is((Object)1));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).getRejectionsOverTime();
    }

    @Test
    void getThrottlesOverTime() {
        TimedDataBuffer throttles = new TimedDataBuffer();
        throttles.put((Object)"b");
        throttles.put((Object)"c");
        Mockito.when((Object)this.scheduler.getThrottlesOverTime()).thenReturn((Object)throttles);
        MatcherAssert.assertThat((Object)((Integer)this.schedulerView.getThrottlesOverTime().forLast60MinsInterval()), (Matcher)Is.is((Object)2));
        ((ReportableScheduler)Mockito.verify((Object)this.scheduler)).getThrottlesOverTime();
    }
}

