/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Feature;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.SchedulerServiceContractTestCase;

@Feature(value="Scheduler Service")
public class UberPoolSchedulerServiceTestCase
extends SchedulerServiceContractTestCase {
    @Test
    public void allSchedulerTypesShareSamePool() throws Exception {
        Set groups = Collections.newSetFromMap(new ConcurrentHashMap());
        CountDownLatch latch = new CountDownLatch(3);
        Runnable task = () -> {
            groups.add(Thread.currentThread().getThreadGroup());
            latch.countDown();
        };
        this.service.cpuLightScheduler().submit(task);
        this.service.cpuIntensiveScheduler().submit(task);
        this.service.ioScheduler().submit(task);
        MatcherAssert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(groups, (Matcher)Matchers.hasSize((int)1));
        ThreadGroup group = (ThreadGroup)groups.iterator().next();
        MatcherAssert.assertThat((Object)group, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)Thread.currentThread().getThreadGroup()))));
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)Matchers.containsString((String)"testuber"));
    }

    @Test
    public void threadsNamedCorrectly() throws Exception {
        CountDownLatch latch = new CountDownLatch(3);
        Runnable task = latch::countDown;
        this.service.cpuLightScheduler().submit(task);
        this.service.cpuIntensiveScheduler().submit(task);
        this.service.ioScheduler().submit(task);
        MatcherAssert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        AtomicInteger uberCount = new AtomicInteger(0);
        Thread.getAllStackTraces().keySet().forEach(thread -> {
            MatcherAssert.assertThat((Object)thread.getName(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)ThreadType.IO.name())));
            MatcherAssert.assertThat((Object)thread.getName(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)ThreadType.CPU_LIGHT.name())));
            MatcherAssert.assertThat((Object)thread.getName(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)ThreadType.CPU_INTENSIVE.name())));
            if (thread.getName().contains("testuber")) {
                uberCount.addAndGet(1);
            }
        });
        MatcherAssert.assertThat((Object)uberCount.get(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
    }

    @Override
    protected String getCpuLightPrefix() {
        return "IO - uber";
    }

    @Override
    protected boolean areCpuLightTasksInWaitGroup() {
        return true;
    }

    @Override
    protected boolean areIoTasksInWaitGroup() {
        return true;
    }

    @Override
    protected boolean areCpuLightTasksInCpuWorkGroup() {
        return true;
    }

    @Override
    protected boolean areIoTasksInCpuWorkGroup() {
        return true;
    }

    @Override
    protected String getSplashMessage() {
        return "uber.threadPool.maxSize:         " + this.config.getUberMaxPoolSize().getAsInt() + System.lineSeparator() + "uber.threadPool.threadKeepAlive: " + this.config.getUberKeepAlive().getAsLong() + " ms" + System.lineSeparator();
    }

    @Override
    protected void configure(SchedulerPoolsConfig config) {
        Mockito.when((Object)config.getSchedulerPoolStrategy()).thenReturn((Object)SchedulerPoolStrategy.UBER);
        Mockito.when((Object)config.getUberCorePoolSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getUberMaxPoolSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getUberQueueSize()).thenReturn((Object)OptionalInt.of(0));
        Mockito.when((Object)config.getUberKeepAlive()).thenReturn((Object)OptionalLong.of(30000L));
    }
}

