/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractMuleExecutorTestCase
extends BaseDefaultSchedulerTestCase {
    private Function<AbstractMuleExecutorTestCase, ScheduledExecutorService> executorFactory;
    protected ScheduledExecutorService executor;

    public AbstractMuleExecutorTestCase(Function<AbstractMuleExecutorTestCase, ScheduledExecutorService> executorFactory, String param) {
        this.executorFactory = executorFactory;
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({test -> test.createScheduledSameThreadExecutor(), "mule,syncQueue"}, {test -> test.createScheduledSameThreadExecutor(), "mule,queue(1)"});
    }

    @Override
    public void before() throws Exception {
        super.before();
        this.executor = this.createExecutor();
    }

    @Override
    public void after() throws Exception {
        this.executor.shutdownNow();
        this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        super.after();
    }

    @Override
    protected ScheduledExecutorService createExecutor() {
        return this.executorFactory.apply(this);
    }

    protected ScheduledExecutorService createScheduledSameThreadExecutor() {
        return super.createExecutor();
    }
}

