/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.metadata.api.model.MetadataType;
import org.mule.module.apikit.metadata.internal.utils.CommonMetadataFactory;

class CommonMetadataFactoryTest {
    CommonMetadataFactoryTest() {
    }

    @Test
    void testDefaultMetadata() {
        MetadataType result = CommonMetadataFactory.defaultMetadata();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"org.mule.metadata.api.model.impl.DefaultAnyType", (Object)result.getClass().getName());
    }

    @Test
    void testFromXSDSchemaWithValidSchema() {
        String validXsdSchema = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">  <xs:element name=\"root\">    <xs:complexType>      <xs:sequence>        <xs:element name=\"child\" type=\"xs:string\"/>      </xs:sequence>    </xs:complexType>  </xs:element></xs:schema>";
        MetadataType result = CommonMetadataFactory.fromXSDSchema((String)validXsdSchema);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testFromXSDSchemaWithInvalidSchema() {
        String invalidXsdSchema = "This is not a valid XSD schema";
        MetadataType result = CommonMetadataFactory.fromXSDSchema((String)invalidXsdSchema);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)CommonMetadataFactory.defaultMetadata(), (Object)result);
    }

    @Test
    void testFromXSDSchemaWithNoRootElement() {
        String noRootElementSchema = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">  <xs:complexType name=\"testType\">    <xs:sequence>      <xs:element name=\"child\" type=\"xs:string\"/>    </xs:sequence>  </xs:complexType></xs:schema>";
        MetadataType result = CommonMetadataFactory.fromXSDSchema((String)noRootElementSchema);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)CommonMetadataFactory.defaultMetadata(), (Object)result);
    }

    @Test
    void testFromXMLExampleWithInvalidXML() {
        String invalidXmlExample = "This is not a valid XML";
        MetadataType result = CommonMetadataFactory.fromXMLExample((String)invalidXmlExample);
        Assertions.assertNull((Object)result);
    }

    @Test
    void testConstantsValuesAndFromXMLExample() {
        Assertions.assertEquals((Object)"application/json", (Object)"application/json");
        Assertions.assertEquals((Object)"application/xml", (Object)"application/xml");
        Assertions.assertEquals((Object)"multipart/form-data", (Object)"multipart/form-data");
        Assertions.assertEquals((Object)"application/x-www-form-urlencoded", (Object)"application/x-www-form-urlencoded");
        Assertions.assertNotNull((Object)CommonMetadataFactory.fromXMLExample((String)"<child>value</child>"));
    }
}

