/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.raml;

import java.lang.reflect.Field;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.apikit.model.ApiSpecification;
import org.mule.apikit.model.api.ApiReference;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.module.apikit.metadata.internal.raml.RamlHandler;
import org.mule.parser.service.ParserService;
import org.mule.parser.service.result.ParseResult;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;

class RamlHandlerTest {
    @Mock
    private ResourceLoader resourceLoader;
    @Mock
    private Notifier notifier;
    @Mock
    private ParserService parserService;
    @Mock
    private ParseResult parseResult;
    @Mock
    private ApiSpecification apiSpecification;
    private RamlHandler ramlHandler;

    RamlHandlerTest() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.ramlHandler = new RamlHandler(this.resourceLoader, this.notifier);
        try {
            Field field = RamlHandler.class.getDeclaredField("SERVICE");
            field.setAccessible(true);
            field.set(this.ramlHandler, this.parserService);
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed to set mocked ParserService");
        }
    }

    @Test
    void testGetMetadataResolverWithValidApiDefinition() {
        String validApiDefinition = "valid-api.raml";
        Mockito.when((Object)this.parserService.parse((ApiReference)ArgumentMatchers.any())).thenReturn((Object)this.parseResult);
        Mockito.when((Object)this.parseResult.success()).thenReturn((Object)true);
        Mockito.when((Object)this.parseResult.get()).thenReturn((Object)this.apiSpecification);
        Optional result = this.ramlHandler.getMetadataResolver(validApiDefinition);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertTrue((boolean)(result.get() instanceof RamlApiWrapper));
    }

    @Test
    void testGetMetadataResolverWithEmptyApiDefinition() {
        String emptyApiDefinition = "";
        Optional result = this.ramlHandler.getMetadataResolver(emptyApiDefinition);
        Assertions.assertFalse((boolean)result.isPresent());
        ((Notifier)Mockito.verify((Object)this.notifier)).error("RAML document is undefined.");
    }

    @Test
    void testGetApiWithValidUri() {
        String validUri = "valid-api.raml";
        Mockito.when((Object)this.parserService.parse((ApiReference)ArgumentMatchers.any())).thenReturn((Object)this.parseResult);
        Mockito.when((Object)this.parseResult.success()).thenReturn((Object)true);
        Mockito.when((Object)this.parseResult.get()).thenReturn((Object)this.apiSpecification);
        Optional result = this.ramlHandler.getApi(validUri);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)this.apiSpecification, result.get());
    }

    @Test
    void testGetApiWithEmptyUri() {
        String emptyUri = "";
        Optional result = this.ramlHandler.getApi(emptyUri);
        Assertions.assertFalse((boolean)result.isPresent());
        ((Notifier)Mockito.verify((Object)this.notifier)).error("RAML document is undefined.");
    }

    @Test
    void testGetApiWithExceptionThrown() {
        String exceptionUri = "exception-api.raml";
        Mockito.when((Object)this.parserService.parse((ApiReference)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("Test exception")});
        Optional result = this.ramlHandler.getApi(exceptionUri);
        Assertions.assertFalse((boolean)result.isPresent());
        ((Notifier)Mockito.verify((Object)this.notifier)).error(Mockito.contains((String)"Error reading RAML document"));
    }
}

