/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.module.apikit.metadata.internal.model.ApplicationModelWrapper;
import org.mule.module.apikit.metadata.internal.model.Flow;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

public class ApplicationModelWrapperTest {
    @Mock
    private ArtifactAst mockArtifactAst;
    @Mock
    private ResourceLoader mockResourceLoader;
    @Mock
    private Notifier mockNotifier;
    private ApplicationModelWrapper applicationModelWrapper;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.applicationModelWrapper = new ApplicationModelWrapper(this.mockArtifactAst, this.mockResourceLoader, this.mockNotifier);
    }

    @Test
    public void testGetApiCoordinateWithNonExistingFlow() {
        Optional result = this.applicationModelWrapper.getApiCoordinate("nonExistingFlow");
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testFindFlows() {
        ComponentAst flow1 = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentAst flow2 = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.mockArtifactAst.topLevelComponentsStream()).thenReturn(Arrays.asList(flow1, flow2).stream());
        Mockito.when((Object)flow1.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"flow"));
        Mockito.when((Object)flow2.getIdentifier()).thenReturn((Object)ComponentIdentifier.buildFromStringRepresentation((String)"flow"));
        Mockito.when((Object)flow1.getComponentId()).thenReturn(Optional.of("flow1"));
        Mockito.when((Object)flow2.getComponentId()).thenReturn(Optional.of("flow2"));
        List flows = this.applicationModelWrapper.findFlows();
        Assertions.assertEquals((int)2, (int)flows.size());
        Assertions.assertEquals((Object)"flow1", (Object)((Flow)flows.get(0)).getName());
        Assertions.assertEquals((Object)"flow2", (Object)((Flow)flows.get(1)).getName());
    }
}

