/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Request;
import amf.apicontract.client.platform.model.domain.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.internal.amf.FlowMetadata;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.runtime.apikit.metadata.api.Notifier;

class FlowMetadataTest {
    @Mock
    private EndPoint endPoint;
    @Mock
    private Operation operation;
    @Mock
    private ApiCoordinate coordinate;
    @Mock
    private Notifier notifier;
    @Mock
    private Response response;
    private FlowMetadata flowMetadata;

    FlowMetadataTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        HashMap baseUriParameters = new HashMap();
        this.flowMetadata = new FlowMetadata(this.endPoint, this.operation, this.coordinate, baseUriParameters, this.notifier);
    }

    @Test
    void testGetMetadata() {
        Response response = new Response();
        response.withStatusCode("200");
        Mockito.when((Object)this.operation.responses()).thenReturn(Collections.singletonList(response));
        Mockito.when((Object)this.operation.request()).thenReturn(Mockito.mock(Request.class));
        Optional result = this.flowMetadata.getMetadata();
        Assertions.assertTrue((boolean)result.isPresent());
        FunctionType functionType = (FunctionType)result.get();
        Assertions.assertEquals((int)1, (int)functionType.getParameters().size());
        Assertions.assertNotNull((Object)functionType.getReturnType());
    }

    @Test
    void testGetMetadataWithNoRequestAndResponse() {
        Mockito.when((Object)this.operation.request()).thenReturn(null);
        Mockito.when((Object)this.operation.responses()).thenReturn(Collections.emptyList());
        Optional result = this.flowMetadata.getMetadata();
        Assertions.assertTrue((boolean)result.isPresent());
        FunctionType functionType = (FunctionType)result.get();
        Assertions.assertEquals((int)1, (int)functionType.getParameters().size());
        Assertions.assertNotNull((Object)functionType.getReturnType());
    }
}

