/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.apicontract.client.platform.model.domain.EndPoint;
import amf.apicontract.client.platform.model.domain.Operation;
import amf.apicontract.client.platform.model.domain.Parameter;
import amf.apicontract.client.platform.model.domain.Server;
import amf.apicontract.client.platform.model.domain.api.WebApi;
import amf.core.client.platform.model.StrField;
import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.module.apikit.metadata.internal.amf.AmfWrapper;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.runtime.apikit.metadata.api.Notifier;

class AmfWrapperTest {
    @Mock
    private WebApi webApi;
    @Mock
    private Notifier notifier;
    @Mock
    private EndPoint endPoint;
    @Mock
    private Operation operation;
    @Mock
    private Server server;
    @Mock
    private Parameter parameter;
    @Mock
    private StrField endpointPath;
    @Mock
    private StrField webApiVersion;
    @Mock
    private StrField parameterName;
    @Mock
    private StrField operationMethod;
    private AmfWrapper amfWrapper;

    AmfWrapperTest() {
    }

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.webApi.endPoints()).thenReturn(Collections.singletonList(this.endPoint));
        Mockito.when((Object)this.endPoint.path()).thenReturn((Object)this.endpointPath);
        Mockito.when((Object)this.endpointPath.value()).thenReturn((Object)"/api/{version}/resource");
        Mockito.when((Object)this.webApi.version()).thenReturn((Object)this.webApiVersion);
        Mockito.when((Object)this.webApiVersion.value()).thenReturn((Object)"v1");
        Mockito.when((Object)this.webApi.servers()).thenReturn(Collections.singletonList(this.server));
        Mockito.when((Object)this.server.variables()).thenReturn(Collections.singletonList(this.parameter));
        Mockito.when((Object)this.parameter.name()).thenReturn((Object)this.parameterName);
        Mockito.when((Object)this.parameterName.value()).thenReturn((Object)"baseUri");
        this.amfWrapper = new AmfWrapper(this.webApi, this.notifier);
    }

    @Test
    void testResolveVersion() {
        String result = this.amfWrapper.resolveVersion("/api/{version}/resource", "v1");
        Assert.assertEquals((Object)"/api/v1/resource", (Object)result);
    }

    @Test
    void testResolveVersionWithoutVersionPlaceholder() {
        String result = this.amfWrapper.resolveVersion("/api/resource", "v1");
        Assert.assertEquals((Object)"/api/resource", (Object)result);
    }

    @Test
    void testResolveVersionWithEmptyVersion() {
        String result = this.amfWrapper.resolveVersion("/api/{version}/resource", "");
        Assert.assertEquals((Object)"/api/{version}/resource", (Object)result);
    }

    @Test
    void testGetMetadataSourceNotFound() {
        ApiCoordinate coordinate = new ApiCoordinate("config1", "/non-existent", "POST", "application/json", "config1:POST:/non-existent");
        Optional result = this.amfWrapper.getMetadataSource(coordinate, "httpStatus", "outboundHeaders");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    void testGetMetadataSourceOperationNotFound() {
        Mockito.when((Object)this.endPoint.operations()).thenReturn(Collections.singletonList(this.operation));
        Mockito.when((Object)this.operation.method()).thenReturn((Object)this.operationMethod);
        Mockito.when((Object)this.operationMethod.value()).thenReturn((Object)"POST");
        ApiCoordinate coordinate = new ApiCoordinate("config1", "/api/v1/resource", "POST", "application/json", "config1:POST:/api/v1/resource");
        Optional result = this.amfWrapper.getMetadataSource(coordinate, "httpStatus", "outboundHeaders");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    void testBaseUriParametersWithEmptyServers() {
        Mockito.when((Object)this.webApi.servers()).thenReturn(Collections.emptyList());
        AmfWrapper emptyServerAmfWrapper = new AmfWrapper(this.webApi, this.notifier);
        ApiCoordinate coordinate = new ApiCoordinate("config1", "/api/v1/resource", "GET", "application/json", "config1:GET:/api/v1/resource");
        Optional result = emptyServerAmfWrapper.getMetadataSource(coordinate, "httpStatus", "outboundHeaders");
        Assert.assertFalse((boolean)result.isPresent());
    }
}

