/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.module.apikit.metadata.internal.model.HttpRequestAttributesFields;

public class MetadataDetectionChangesTest {
    @Test
    public void httpRequestAttributesChanges() {
        Set currentFields = Arrays.stream(HttpRequestAttributesFields.values()).map(HttpRequestAttributesFields::getName).collect(Collectors.toSet());
        Set expectedFields = MetadataDetectionChangesTest.getAllFields(new ArrayList<Field>(), HttpRequestAttributes.class).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> Modifier.isPrivate(f.getModifiers()) || Modifier.isProtected(f.getModifiers())).map(Field::getName).collect(Collectors.toSet());
        MatcherAssert.assertThat((Object)Sets.difference(expectedFields, currentFields).size(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)Sets.difference(currentFields, expectedFields).size(), (Matcher)Is.is((Object)0));
    }

    private static Stream<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            MetadataDetectionChangesTest.getAllFields(fields, type.getSuperclass());
        }
        return fields.stream();
    }
}

