/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Rule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class TestDataProvider {
    protected final File input;
    protected final Map<String, String> expectedMap;
    protected Map<String, String> currentMap;
    protected final String name;
    @Rule
    public TestWatcher watchman = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            this.updateTests();
        }

        private void updateTests() {
            if (System.getProperty("updateTests") != null) {
                try {
                    String inputPath = TestDataProvider.this.input.getPath().replace("target/test-classes", "src/test/resources");
                    Path basePath = Paths.get(inputPath, new String[0]).getParent();
                    Files.walk(basePath, 1, new FileVisitOption[0]).map(Path::toFile).filter(f -> f.isFile() && f.getName().endsWith(".out")).forEach(File::delete);
                    TestDataProvider.this.currentMap.forEach((name, content) -> {
                        try {
                            Files.write(basePath.resolve((String)name), content.getBytes("UTF-8"), new OpenOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    };

    public TestDataProvider(File input, Map<String, String> expectedMap, String name) {
        this.input = input;
        this.expectedMap = expectedMap;
        this.name = name;
    }

    public static Collection<Object[]> getData(URI baseFolder, String inputFileName, Pattern outputPattern) throws IOException {
        return TestDataProvider.collectParameters(baseFolder, inputFileName, outputPattern);
    }

    private static String readFile(File file) {
        try {
            return new String(Files.readAllBytes(Paths.get(file.toURI())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Object[]> collectParameters(URI folderPath, String inputFileName, Pattern outputPattern) throws IOException {
        TestFileVisitor visitor = TestFileVisitor.create(inputFileName, outputPattern);
        Files.walkFileTree(Paths.get(folderPath), visitor);
        return visitor.getParameters();
    }

    private static class TestFileVisitor
    extends SimpleFileVisitor<Path> {
        private final String inputName;
        private final Pattern outputPattern;
        private final List<File> outputFiles = new ArrayList<File>();
        private File inputFile = null;
        private final List<Object[]> parameters = new ArrayList<Object[]>();

        private List<Object[]> getParameters() {
            return this.parameters;
        }

        private TestFileVisitor(String inputName, Pattern outputPattern) {
            this.inputName = inputName;
            this.outputPattern = outputPattern;
        }

        static TestFileVisitor create(String input, Pattern outputPattern) {
            return new TestFileVisitor(input, outputPattern);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            File candidate = file.toFile();
            String name = candidate.getName();
            if (name.equals(this.inputName)) {
                this.inputFile = candidate;
            } else if (this.outputPattern.matcher(name).matches()) {
                this.outputFiles.add(candidate);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path scenarioPath, BasicFileAttributes attrs) throws IOException {
            if (!scenarioPath.endsWith("include") && !scenarioPath.toString().contains("exchange")) {
                this.outputFiles.clear();
                this.inputFile = null;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            File scenarioDir = dir.toFile();
            if (this.inputFile != null && !dir.endsWith("include") && !dir.toString().contains("exchange")) {
                Map<String, String> outputMap = this.outputFiles.stream().collect(Collectors.toMap(File::getName, x$0 -> TestDataProvider.readFile(x$0)));
                this.parameters.add(new Object[]{this.inputFile, outputMap, scenarioDir.getName()});
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

