/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.utils;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.module.apikit.metadata.utils.ApplicationModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;

public class MockedApplicationModel
implements ApplicationModel {
    private final ArtifactAst applicationModel;
    private final List<String> typesDataList;

    private MockedApplicationModel(ArtifactAst applicationModel, List<String> typesDataList) {
        this.applicationModel = applicationModel;
        this.typesDataList = new ArrayList<String>();
        this.typesDataList.addAll(typesDataList);
    }

    @Override
    public Optional<URI> findResource(String resource) {
        return Optional.empty();
    }

    @Override
    public ArtifactAst getMuleApplicationModel() {
        return this.applicationModel;
    }

    @Override
    public Optional<ComponentAst> findNamedComponent(String name) {
        return this.getMuleApplicationModel().topLevelComponentsStream().filter(comp -> name.equals(comp.getComponentId().orElse(null))).findFirst();
    }

    @Override
    public List<String> findTypesDataList() {
        return this.typesDataList;
    }

    public static class Builder {
        private URI configURI;
        private List<String> typesDataList = new ArrayList<String>();
        private ExtensionManager extensionManager;

        public Builder extensionManager(ExtensionManager extensionManager) {
            this.extensionManager = extensionManager;
            return this;
        }

        public Builder addConfig(File configData) {
            this.configURI = configData.toURI();
            return this;
        }

        public MockedApplicationModel build() {
            Set extensionModels = this.extensionManager.getExtensions();
            ArtifactAst applicationModel = AstXmlParser.builder().withExtensionModels((Collection)extensionModels).withExtensionModels(Builder.loadRuntimeExtensionModels()).withSchemaValidationsDisabled().build().parse(new URI[]{this.configURI});
            return new MockedApplicationModel(applicationModel, this.typesDataList);
        }

        private static List<ExtensionModel> loadRuntimeExtensionModels() {
            Collection runtimeExtensionModelProviders = new SpiServiceRegistry().lookupProviders(RuntimeExtensionModelProvider.class, Thread.currentThread().getContextClassLoader());
            ArrayList<ExtensionModel> runtimeExtensionModels = new ArrayList<ExtensionModel>();
            for (RuntimeExtensionModelProvider runtimeExtensionModelProvider : runtimeExtensionModelProviders) {
                runtimeExtensionModels.add(runtimeExtensionModelProvider.createExtensionModel());
            }
            return runtimeExtensionModels;
        }
    }
}

