/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.metadata.api.model.FunctionType;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.ApikitConfig;
import org.mule.module.apikit.metadata.internal.model.ApplicationModelWrapper;
import org.mule.module.apikit.metadata.internal.model.MetadataModel;
import org.mule.module.apikit.metadata.internal.raml.RamlApiWrapper;
import org.mule.runtime.apikit.metadata.api.MetadataSource;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.ast.api.ArtifactAst;

class MetadataModelTest {
    @Mock
    private ArtifactAst artifactAst;
    @Mock
    private ResourceLoader resourceLoader;
    @Mock
    private Notifier notifier;
    @Mock
    private ApplicationModelWrapper applicationModelWrapper;
    @Mock
    private ApikitConfig apikitConfig;
    @Mock
    private MetadataSource metadataSource;
    @Mock
    private FunctionType functionType;
    @Mock
    private RamlApiWrapper ramlApiWrapper;
    private MetadataModel metadataModel;

    MetadataModelTest() {
    }

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.applicationModelWrapper.getApiCoordinate(Mockito.anyString())).thenReturn(Optional.of(new ApiCoordinate("configName", "flowName", "", "", "")));
        Mockito.when((Object)this.applicationModelWrapper.getConfig(Mockito.anyString())).thenReturn(Optional.of(this.apikitConfig));
        Mockito.when((Object)this.apikitConfig.getMetadataResolver()).thenReturn(Optional.of(this.ramlApiWrapper));
        Mockito.when((Object)this.metadataSource.getMetadata()).thenReturn(Optional.of(this.functionType));
        this.metadataModel = new MetadataModel(this.artifactAst, this.resourceLoader, this.notifier);
    }

    @Test
    void testGetMetadataForFlow_NoCoordinate() {
        Mockito.when((Object)this.applicationModelWrapper.getApiCoordinate(Mockito.anyString())).thenReturn(Optional.empty());
        Optional result = this.metadataModel.getMetadataForFlow("flowName");
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    void testGetMetadataForFlow_NoConfig() {
        Mockito.when((Object)this.applicationModelWrapper.getConfig(Mockito.anyString())).thenReturn(Optional.empty());
        Optional result = this.metadataModel.getMetadataForFlow("flowName");
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    void testGetMetadataForFlow_NoMetadataResolver() {
        Mockito.when((Object)this.apikitConfig.getMetadataResolver()).thenReturn(Optional.empty());
        Optional result = this.metadataModel.getMetadataForFlow("flowName");
        Assertions.assertFalse((boolean)result.isPresent());
    }

    @Test
    void testGetMetadataForFlow_NoMetadataSource() {
        Mockito.when((Object)this.metadataSource.getMetadata()).thenReturn(Optional.empty());
        Optional result = this.metadataModel.getMetadataForFlow("flowName");
        Assertions.assertFalse((boolean)result.isPresent());
    }
}

