/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.module.apikit.metadata.internal.model.Flow;
import org.mule.module.apikit.metadata.internal.model.FlowMapping;

public class FlowMappingTest {
    @Test
    public void testFlowMappingConstructorAndGetters() {
        String configName = "testConfig";
        String resource = "/api/users";
        String action = "GET";
        String contentType = "application/json";
        String flowRef = "getUsers";
        FlowMapping flowMapping = new FlowMapping(configName, resource, action, contentType, flowRef);
        Assertions.assertEquals((Object)configName, (Object)flowMapping.getConfigName());
        Assertions.assertEquals((Object)resource, (Object)flowMapping.getResource());
        Assertions.assertEquals((Object)action, (Object)flowMapping.getAction());
        Assertions.assertEquals((Object)contentType, (Object)flowMapping.getContentType());
        Assertions.assertEquals((Object)flowRef, (Object)flowMapping.getFlowRef());
    }

    @Test
    public void testFlowMappingWithNullValues() {
        FlowMapping flowMapping = new FlowMapping(null, null, null, null, null);
        Assertions.assertNull((Object)flowMapping.getConfigName());
        Assertions.assertNull((Object)flowMapping.getResource());
        Assertions.assertNull((Object)flowMapping.getAction());
        Assertions.assertNull((Object)flowMapping.getContentType());
        Assertions.assertNull((Object)flowMapping.getFlowRef());
    }

    @Test
    public void testFlowMappingWithEmptyStrings() {
        FlowMapping flowMapping = new FlowMapping("", "", "", "", "");
        Assertions.assertEquals((Object)"", (Object)flowMapping.getConfigName());
        Assertions.assertEquals((Object)"", (Object)flowMapping.getResource());
        Assertions.assertEquals((Object)"", (Object)flowMapping.getAction());
        Assertions.assertEquals((Object)"", (Object)flowMapping.getContentType());
        Assertions.assertEquals((Object)"", (Object)flowMapping.getFlowRef());
    }

    @Test
    public void testFlowMappingWithSpecialCharacters() {
        String configName = "config#1";
        String resource = "/api/users/{id}";
        String action = "POST";
        String contentType = "application/xml; charset=UTF-8";
        String flowRef = "create_user_flow";
        FlowMapping flowMapping = new FlowMapping(configName, resource, action, contentType, flowRef);
        Assertions.assertEquals((Object)configName, (Object)flowMapping.getConfigName());
        Assertions.assertEquals((Object)resource, (Object)flowMapping.getResource());
        Assertions.assertEquals((Object)action, (Object)flowMapping.getAction());
        Assertions.assertEquals((Object)contentType, (Object)flowMapping.getContentType());
        Assertions.assertEquals((Object)flowRef, (Object)flowMapping.getFlowRef());
    }

    @Test
    public void testFlowtoString() {
        Flow flow = new Flow("flowName");
        Assertions.assertEquals((Object)"flowName", (Object)flow.toString());
    }
}

