/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mock;
import org.mule.module.apikit.metadata.internal.amf.AmfHandler;
import org.mule.module.apikit.metadata.internal.amf.AutoHandler;
import org.mule.module.apikit.metadata.internal.model.ApikitConfig;
import org.mule.module.apikit.metadata.internal.model.FlowMapping;
import org.mule.module.apikit.metadata.internal.model.MetadataResolver;
import org.mule.module.apikit.metadata.internal.model.MetadataResolverFactory;
import org.mule.module.apikit.metadata.internal.raml.RamlHandler;
import org.mule.module.apikit.metadata.utils.TestNotifier;
import org.mule.module.apikit.metadata.utils.TestResourceLoader;
import org.mule.parser.service.ParserMode;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;

class ApikitConfigTest {
    @Mock
    private ResourceLoader resourceLoader;
    @Mock
    private Notifier notifier;
    @Mock
    private MetadataResolver metadataResolver;
    private ApikitConfig apikitConfig;

    ApikitConfigTest() {
    }

    @BeforeEach
    void setUp() {
        this.notifier = new TestNotifier();
        this.resourceLoader = new TestResourceLoader();
        List<FlowMapping> flowMappings = Arrays.asList(new FlowMapping("testConfig", "/api/users", "GET", "application/json", "getUsers"));
        this.apikitConfig = new ApikitConfig("testConfig", "api.raml", flowMappings, "httpStatus", "outHeaders", "RAML", this.resourceLoader, this.notifier);
    }

    @Test
    void testGetName() {
        Assertions.assertEquals((Object)"testConfig", (Object)this.apikitConfig.getName());
    }

    @Test
    void testGetMetadataResolver() {
        Assertions.assertFalse((boolean)this.apikitConfig.getMetadataResolver().isPresent());
    }

    @Test
    void testGetFlowMappings() {
        Assertions.assertEquals((int)1, (int)this.apikitConfig.getFlowMappings().size());
        Assertions.assertEquals((Object)"/api/users", (Object)((FlowMapping)this.apikitConfig.getFlowMappings().get(0)).getResource());
    }

    @Test
    void testGetHttpStatusVarName() {
        Assertions.assertEquals((Object)"httpStatus", (Object)this.apikitConfig.getHttpStatusVarName());
    }

    @Test
    void testGetOutputHeadersVarName() {
        Assertions.assertEquals((Object)"outHeaders", (Object)this.apikitConfig.getOutputHeadersVarName());
    }

    @ParameterizedTest
    @EnumSource(value=ParserMode.class)
    void testGetMetadataResolverFactory(ParserMode parserMode) {
        ApikitConfig config = new ApikitConfig("testConfig", "api.raml", null, null, null, parserMode.name(), this.resourceLoader, this.notifier);
        MetadataResolverFactory factory = this.getMetadataResolverFactoryUsingReflection(config);
        Assertions.assertNotNull((Object)factory);
        Class<?> expectedClass = this.getExpectedFactoryClass(parserMode);
        Assertions.assertEquals(expectedClass, factory.getClass());
    }

    private MetadataResolverFactory getMetadataResolverFactoryUsingReflection(ApikitConfig config) {
        try {
            Method method = ApikitConfig.class.getDeclaredMethod("getMetadataResolverFactory", new Class[0]);
            method.setAccessible(true);
            return (MetadataResolverFactory)method.invoke((Object)config, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke getMetadataResolverFactory using reflection", e);
        }
    }

    private Class<?> getExpectedFactoryClass(ParserMode parserMode) {
        switch (parserMode) {
            case RAML: {
                return RamlHandler.class;
            }
            case AMF: {
                return AmfHandler.class;
            }
        }
        return AutoHandler.class;
    }
}

