/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinate;
import org.mule.module.apikit.metadata.internal.model.ApiCoordinateFactory;
import org.mule.module.apikit.metadata.internal.model.FlowMapping;

public class ApiCoordinateFactoryTest {
    @Test
    public void twoConfigsTest() {
        ApiCoordinateFactory factory = new ApiCoordinateFactory(this.set("config1", "config2"));
        Optional coord = factory.fromFlowName("get:\\persons:config1");
        Assertions.assertTrue((boolean)coord.isPresent());
        Assertions.assertEquals((Object)"get:\\persons:config1", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assertions.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assertions.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assertions.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assertions.assertEquals((Object)"config1", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("post:\\offices:config2");
        Assertions.assertTrue((boolean)coord.isPresent());
        Assertions.assertEquals((Object)"post:\\offices:config2", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assertions.assertEquals((Object)"post", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assertions.assertEquals((Object)"/offices", (Object)((ApiCoordinate)coord.get()).getResource());
        Assertions.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assertions.assertEquals((Object)"config2", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("post:\\offices:application\\json:config2");
        Assertions.assertTrue((boolean)coord.isPresent());
        Assertions.assertEquals((Object)"post:\\offices:application\\json:config2", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assertions.assertEquals((Object)"post", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assertions.assertEquals((Object)"/offices", (Object)((ApiCoordinate)coord.get()).getResource());
        Assertions.assertEquals((Object)"application/json", (Object)((ApiCoordinate)coord.get()).getMediaType());
        Assertions.assertEquals((Object)"config2", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("get:\\persons:config3");
        Assertions.assertFalse((boolean)coord.isPresent());
        coord = factory.fromFlowName("post:\\offices");
        Assertions.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
        coord = factory.fromFlowName("post:\\incomplete:application\\json:config2:illegal");
        Assertions.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
        coord = factory.fromFlowName("post:\\offices:application\\json:unknown-config");
        Assertions.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
        coord = factory.fromFlowName("get:");
        Assertions.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void oneConfigTest() {
        ApiCoordinateFactory factory = new ApiCoordinateFactory(this.set("config"));
        Optional coord = factory.fromFlowName("get:\\persons");
        Assertions.assertTrue((boolean)coord.isPresent());
        Assertions.assertEquals((Object)"get:\\persons", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assertions.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assertions.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assertions.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assertions.assertNull((Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("get:\\persons");
        Assertions.assertTrue((boolean)coord.isPresent());
        Assertions.assertEquals((Object)"get:\\persons", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assertions.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assertions.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assertions.assertNull((Object)((ApiCoordinate)coord.get()).getMediaType());
        Assertions.assertNull((Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("get:\\persons:application\\json:config");
        Assertions.assertTrue((boolean)coord.isPresent());
        Assertions.assertEquals((Object)"get:\\persons:application\\json:config", (Object)((ApiCoordinate)coord.get()).getFlowName());
        Assertions.assertEquals((Object)"get", (Object)((ApiCoordinate)coord.get()).getMethod());
        Assertions.assertEquals((Object)"/persons", (Object)((ApiCoordinate)coord.get()).getResource());
        Assertions.assertEquals((Object)"application/json", (Object)((ApiCoordinate)coord.get()).getMediaType());
        Assertions.assertEquals((Object)"config", (Object)((ApiCoordinate)coord.get()).getConfigName());
        coord = factory.fromFlowName("get:\\persons:application\\json:unknownConfig");
        Assertions.assertTrue((!coord.isPresent() ? 1 : 0) != 0);
    }

    @Test
    public void testApiCoordinateFactory() {
        HashSet<String> configNames = new HashSet<String>();
        configNames.add("config1");
        configNames.add("config2");
        ApiCoordinateFactory apiCoordinateFactory = new ApiCoordinateFactory(configNames);
        String flowName = "config1:GET:/users";
        FlowMapping flowMapping = new FlowMapping("config1", "/users", "GET", "application/json", flowName);
        ApiCoordinate coordinate = apiCoordinateFactory.createFromFlowMapping(flowMapping);
        Assertions.assertEquals((Object)"config1", (Object)coordinate.getConfigName());
        Assertions.assertEquals((Object)"GET", (Object)coordinate.getMethod());
        Assertions.assertEquals((Object)"/users", (Object)coordinate.getResource());
        Assertions.assertEquals((Object)"application/json", (Object)coordinate.getMediaType());
        Assertions.assertEquals((Object)flowName, (Object)coordinate.getFlowName());
    }

    private HashSet<String> set(String ... configs) {
        return new HashSet<String>(Arrays.asList(configs));
    }
}

