/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;

public class Http2ConnectionCleanupHandler
extends Http2ChannelDuplexHandler {
    private final Http2ConnectionHandler connectionHandler;

    public Http2ConnectionCleanupHandler(Http2ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Http2Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            int numActiveStreams = this.connectionHandler.connection().numActiveStreams();
            if (IdleState.READER_IDLE == idleStateEvent.state() && numActiveStreams > 0) {
                this.forEachActiveStream(frameStream -> {
                    this.sendTimeoutResponse(ctx, frameStream);
                    return true;
                });
                return;
            }
            if (IdleState.ALL_IDLE == idleStateEvent.state() && numActiveStreams == 0) {
                ctx.close();
                return;
            }
        }
        if (evt instanceof ChannelInputShutdownEvent) {
            ctx.close();
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void sendTimeoutResponse(ChannelHandlerContext ctx, Http2FrameStream frameStream) {
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)String.valueOf(HttpResponseStatus.REQUEST_TIMEOUT.code()));
        DefaultHttp2HeadersFrame rejection = new DefaultHttp2HeadersFrame(headers, false).stream(frameStream);
        ctx.writeAndFlush((Object)rejection);
        ByteBuf buffer = ctx.alloc().buffer();
        buffer.writeBytes("Timeout reading request".getBytes());
        DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(buffer, true).stream(frameStream);
        ctx.writeAndFlush((Object)dataFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

