/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm;

import java.io.IOException;
import java.util.Base64;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import org.mule.service.http.netty.impl.client.auth.NettyAuthHeaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmMessageFactory
implements NettyAuthHeaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NtlmMessageFactory.class);
    private static final int TYPE_1_MESSAGE_FLAGS = -1576500735;
    private static final String NTLM_MESSAGES_PREFIX = "NTLM ";
    private static final String STARTING_NTLM_WWW_AUTHENTICATE_HEADER = "NTLM";
    private final String domain;
    private final String workstation;
    private final String username;
    private final String password;
    private Status status;

    public NtlmMessageFactory(String domain, String workstation, String username, String password) {
        this.domain = null == domain ? "" : domain;
        this.workstation = workstation;
        this.username = username;
        this.password = password;
        this.status = Status.NOT_STARTED;
    }

    public byte[] createType1Message() {
        LOGGER.debug("NTLM MessageFactory creating Type1Message...");
        return RawType1MessageHolder.RAW_TYPE_1_MESSAGE;
    }

    public byte[] createType3Message(byte[] type2Material) throws IOException {
        LOGGER.debug("NTLM MessageFactory creating Type3Message...");
        Type2Message type2Message = new Type2Message(type2Material);
        if (null == type2Message.getChallenge()) {
            type2Message.setChallenge(new byte[0]);
        }
        Type3Message type3Message = new Type3Message(type2Message, this.password, this.domain, this.username, this.workstation, type2Message.getFlags());
        return type3Message.toByteArray();
    }

    protected String secondChallenge(String wwwAuthenticateHeader) throws IOException {
        if (null == wwwAuthenticateHeader) {
            return null;
        }
        byte[] type2Material = Base64.getDecoder().decode(wwwAuthenticateHeader.substring(5));
        return this.createHeaderValue(this.createType3Message(type2Material));
    }

    private boolean mustSendType1(String wwwAuthenticateHeader) {
        return STARTING_NTLM_WWW_AUTHENTICATE_HEADER.equals(wwwAuthenticateHeader.trim());
    }

    private boolean mustSendType3(String wwwAuthenticateHeader) {
        return wwwAuthenticateHeader.startsWith(NTLM_MESSAGES_PREFIX);
    }

    private String createHeaderValue(byte[] rawNtlmMessageContent) {
        return NTLM_MESSAGES_PREFIX + Base64.getEncoder().encodeToString(rawNtlmMessageContent);
    }

    @Override
    public boolean hasFinished() {
        return Status.FINISHED == this.status;
    }

    @Override
    public String getNextHeader(String wwwAuthenticateHeader) throws Exception {
        if (null == wwwAuthenticateHeader) {
            return null;
        }
        String authHeader = null;
        if (Status.NOT_STARTED == this.status) {
            if (this.mustSendType1(wwwAuthenticateHeader)) {
                authHeader = this.createHeaderValue(this.createType1Message());
            }
            this.status = Status.WAITING_FOR_CHALLENGE;
        } else if (Status.WAITING_FOR_CHALLENGE == this.status) {
            if (this.mustSendType3(wwwAuthenticateHeader)) {
                authHeader = this.secondChallenge(wwwAuthenticateHeader);
            }
            this.status = Status.FINISHED;
        }
        return authHeader;
    }

    static enum Status {
        NOT_STARTED,
        WAITING_FOR_CHALLENGE,
        FINISHED;

    }

    private static final class RawType1MessageHolder {
        private static final byte[] RAW_TYPE_1_MESSAGE = RawType1MessageHolder.doCalculateType1Message();

        private RawType1MessageHolder() {
        }

        private static byte[] doCalculateType1Message() {
            Type1Message type1Message = new Type1Message(-1576500735, null, null);
            return type1Message.toByteArray();
        }
    }
}

