/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.DummyRequestHandler;
import org.mule.service.http.test.netty.utils.client.TestSSLNettyClient;
import org.mule.service.http.test.netty.utils.server.TestHttpServer;
import org.mule.tck.junit4.rule.DynamicPort;

public class RehandshakeTestCase
extends AbstractHttpTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestHttpServer server = new TestHttpServer("localhost", this.serverPort.getNumber(), true);
    @Rule
    public TestSSLNettyClient testClient = new TestSSLNettyClient("localhost", this.serverPort.getNumber(), executorRule.getExecutor());

    @Before
    public void setUp() {
        this.server.addRequestHandler("/path", new DummyRequestHandler()).start();
    }

    @Test
    @Issue(value="W-15631497")
    public void testSSLRehandshake() throws Exception {
        String sslEndpoint = "/path";
        HttpResponse initialResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)initialResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.testClient.reHandshake();
        HttpResponse rehandshakeResponse = this.testClient.sendGet(sslEndpoint);
        MatcherAssert.assertThat((Object)rehandshakeResponse.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }
}

