/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server.sse;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.service.http.common.server.sse.SseRequestHandler;
import org.mule.service.http.test.common.AbstractHttpTestCase;

@Feature(value="Server Sent Events (SSE)")
@Story(value="SSE Endpoint")
public class SseRequestHandlerTestCase
extends AbstractHttpTestCase {
    private HttpResponseReadyCallback responseReadyCallback;
    private HttpRequestContext requestContext;
    private HttpRequest httpRequest;
    private InetSocketAddress remoteAddress;

    @BeforeEach
    public void setUp() throws Exception {
        this.responseReadyCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        this.requestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        this.httpRequest = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)this.requestContext.getRequest()).thenReturn((Object)this.httpRequest);
        this.remoteAddress = new InetSocketAddress("localhost", 8081);
        ClientConnection clientConnection = (ClientConnection)Mockito.mock(ClientConnection.class);
        Mockito.when((Object)clientConnection.getRemoteHostAddress()).thenReturn((Object)this.remoteAddress);
        Mockito.when((Object)this.requestContext.getClientConnection()).thenReturn((Object)clientConnection);
    }

    @Test
    public void whenRequestCallbackDoesNotReject_theOnSseClientCallbackIsCalled() {
        Consumer<SseRequestContext> onRequest = requestCtx -> {};
        Consumer onSseClient = (Consumer)Mockito.mock(Consumer.class);
        SseRequestHandler sseRequestHandler = new SseRequestHandler(onRequest, onSseClient);
        sseRequestHandler.handleRequest(this.requestContext, this.responseReadyCallback);
        ((Consumer)Mockito.verify((Object)onSseClient)).accept((SseClient)ArgumentMatchers.any());
    }

    @Test
    public void whenRequestCallbackDoesNotReject_theResponseBodyDeferringMechanismIsUsed() {
        Consumer<SseRequestContext> onRequest = requestCtx -> {};
        Consumer onSseClient = (Consumer)Mockito.mock(Consumer.class);
        SseRequestHandler sseRequestHandler = new SseRequestHandler(onRequest, onSseClient);
        sseRequestHandler.handleRequest(this.requestContext, this.responseReadyCallback);
        ((HttpResponseReadyCallback)Mockito.verify((Object)this.responseReadyCallback)).startResponse((HttpResponse)ArgumentMatchers.any(), (ResponseStatusCallback)ArgumentMatchers.any(), (Charset)ArgumentMatchers.any());
        ((HttpResponseReadyCallback)Mockito.verify((Object)this.responseReadyCallback, (VerificationMode)Mockito.never())).responseReady((HttpResponse)ArgumentMatchers.any(), (ResponseStatusCallback)ArgumentMatchers.any());
    }

    @Test
    public void whenRequestCallbackRejects_theOnSseClientCallbackIsNotCalled() {
        Consumer<SseRequestContext> onRequest = requestCtx -> requestCtx.reject(500, "Expected error");
        Consumer onSseClient = (Consumer)Mockito.mock(Consumer.class);
        SseRequestHandler sseRequestHandler = new SseRequestHandler(onRequest, onSseClient);
        sseRequestHandler.handleRequest(this.requestContext, this.responseReadyCallback);
        ((HttpResponseReadyCallback)Mockito.verify((Object)this.responseReadyCallback, (VerificationMode)Mockito.never())).startResponse((HttpResponse)ArgumentMatchers.any(), (ResponseStatusCallback)ArgumentMatchers.any(), (Charset)ArgumentMatchers.any());
        ((HttpResponseReadyCallback)Mockito.verify((Object)this.responseReadyCallback)).responseReady((HttpResponse)ArgumentMatchers.any(), (ResponseStatusCallback)ArgumentMatchers.any());
    }

    @Test
    public void whenRequestCallbackRejects_theResponseDeferringMechanismIsNotUsed() {
        Consumer<SseRequestContext> onRequest = requestCtx -> requestCtx.reject(500, "Expected error");
        Consumer onSseClient = (Consumer)Mockito.mock(Consumer.class);
        SseRequestHandler sseRequestHandler = new SseRequestHandler(onRequest, onSseClient);
        sseRequestHandler.handleRequest(this.requestContext, this.responseReadyCallback);
        ((Consumer)Mockito.verify((Object)onSseClient, (VerificationMode)Mockito.never())).accept((SseClient)ArgumentMatchers.any());
    }

    @Test
    public void whenRequestCallbackSetsTheId_theOnSseClientCallbackSeesTheId() {
        String overriddenId = "OverriddenId";
        Mockito.when((Object)this.httpRequest.getHeaderValue("X-Override-Id")).thenReturn((Object)overriddenId);
        Consumer<SseRequestContext> onRequest = requestCtx -> {
            String headerValue = requestCtx.getRequest().getHeaderValue("X-Override-Id");
            if (null != headerValue) {
                requestCtx.setClientId(headerValue);
            }
        };
        AtomicReference seenId = new AtomicReference();
        Consumer<SseClient> onSseClient = sseClient -> seenId.set(sseClient.getClientId());
        SseRequestHandler sseRequestHandler = new SseRequestHandler(onRequest, onSseClient);
        sseRequestHandler.handleRequest(this.requestContext, this.responseReadyCallback);
        MatcherAssert.assertThat((Object)((String)seenId.get()), (Matcher)Matchers.is((Object)overriddenId));
    }

    @Test
    public void checkDefaultResponse() {
        Consumer onRequest = (Consumer)Mockito.mock(Consumer.class);
        Consumer onSseClient = (Consumer)Mockito.mock(Consumer.class);
        SseRequestHandler sseRequestHandler = new SseRequestHandler(onRequest, onSseClient);
        sseRequestHandler.handleRequest(this.requestContext, this.responseReadyCallback);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseReadyCallback)Mockito.verify((Object)this.responseReadyCallback)).startResponse((HttpResponse)responseCaptor.capture(), (ResponseStatusCallback)ArgumentMatchers.any(), (Charset)ArgumentMatchers.any());
        HttpResponse response = (HttpResponse)responseCaptor.getValue();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getHeaderNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"content-type", "cache-control", "pragma", "transfer-encoding", "access-control-allow-origin"}));
        MatcherAssert.assertThat((Object)response.getHeaderValue("Content-Type"), (Matcher)Matchers.is((Object)"text/event-stream"));
    }
}

