/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Issue;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;

@Issue(value="W-19068996")
class SimpleClientTestCase
extends AbstractHttpServiceTestCase {
    private HttpClient httpClient;

    public SimpleClientTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() {
        HttpClientConfiguration config = new HttpClientConfiguration.Builder().setName("HTTP/2 Client").build();
        this.httpClient = this.service.getClientFactory().create(config);
        this.httpClient.start();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.stop();
    }

    @Test
    void clientChecksThatUriHasScheme() throws URISyntaxException {
        this.testIncorrectUri("/theUri", "The uri provided '/theUri' must contain a scheme.");
    }

    @Test
    void clientChecksThatUriHasHost() throws URISyntaxException {
        this.testIncorrectUri("https:///theUri", "The uri provided 'https:///theUri' must contain a host.");
    }

    private void testIncorrectUri(String uriString, String expectedMessage) throws URISyntaxException {
        URI uriWithoutHost = new URI(uriString);
        CompletableFuture future = this.httpClient.sendAsync(HttpRequest.builder().uri(uriWithoutHost).build());
        ExecutionException error = (ExecutionException)Assertions.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)error, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)expectedMessage))));
    }
}

