/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.util;

import static org.mule.service.http.netty.impl.util.NettyUtils.shouldWrapAsRemotelyClosed;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;

import io.netty.handler.timeout.ReadTimeoutException;
import org.mule.runtime.api.connection.ConnectionException;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquireTimeoutException;

public class ReactorNettyUtils {

  public static Throwable onErrorMap(Throwable error) {
    if (shouldWrapAsRemotelyClosed(error)) {
      return new IOException("Remotely closed", error);
    } else if (error instanceof ReadTimeoutException) {
      return new TimeoutException("Timeout exceeded");
    } else if (error instanceof URISyntaxException) {
      return new IllegalArgumentException(error);
    } else if (error instanceof PoolAcquireTimeoutException) {
      return new IOException("Connection limit exceeded, cannot process request", error);
    } else if (error instanceof UnknownHostException) {
      return new ConnectionException("Connection Failed. Unresolved Address.", error);
    }
    return error;
  }
}

