/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;

public interface WebSocketsHandlersRegistry {

  /**
   * Adds a {@link WebSocketHandler}
   *
   * @param handler the handler
   * @return a {@link WebSocketHandlerManager}
   */
  default WebSocketHandlerManager addWebSocketHandler(WebSocketHandler handler) {
    throw new UnsupportedOperationException("WebSockets are only supported in Enterprise Edition");
  }
}
