/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionsCounterHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionsCounterHandler.class);
    private int connectionsCount;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.incrementConnectionsCount();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.decrementConnectionsCount();
    }

    private synchronized void incrementConnectionsCount() {
        ++this.connectionsCount;
    }

    private synchronized void decrementConnectionsCount() {
        --this.connectionsCount;
        ((Object)((Object)this)).notifyAll();
    }

    public boolean waitForConnectionsToBeClosed(long timeout, TimeUnit unit) {
        this.doWaitForConnectionsToBeClosed(timeout, unit);
        if (this.connectionsCount > 0) {
            LOGGER.warn("There are still {} open connections on server stop.", (Object)this.connectionsCount);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWaitForConnectionsToBeClosed(long timeout, TimeUnit unit) {
        if (timeout == 0L) {
            return;
        }
        long stopNanos = System.nanoTime() + unit.toNanos(timeout);
        ConnectionsCounterHandler connectionsCounterHandler = this;
        synchronized (connectionsCounterHandler) {
            try {
                long remainingNanos = stopNanos - System.nanoTime();
                while (this.connectionsCount > 0 && remainingNanos > 0L) {
                    long remainingMillis = TimeUnit.NANOSECONDS.toMillis(remainingNanos);
                    long millisToWait = Math.min(remainingMillis, 50L);
                    LOGGER.debug("There are still {} open connections on server stop. Waiting {} milliseconds", (Object)this.connectionsCount, (Object)millisToWait);
                    if (millisToWait > 0L) {
                        ((Object)((Object)this)).wait(millisToWait);
                    } else {
                        ((Object)((Object)this)).wait(0L, (int)remainingNanos);
                    }
                    remainingNanos = stopNanos - System.nanoTime();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

