/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.TcpTextClient;
import org.mule.service.http.test.netty.utils.TestUtils;

@Issue(value="W-17464403")
class ServerConnectionTimeoutTestCase
extends AbstractHttpServerTestCase {
    private static final int SMALL_CONNECTION_TIMEOUT_MILLIS = 500;
    private static final long LARGE_READ_TIMEOUT_MILLIS = 1000000L;

    public ServerConnectionTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected String getServerName() {
        return "test-server";
    }

    @Override
    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder.setConnectionIdleTimeout(500).setReadTimeout(1000000L);
    }

    @BeforeEach
    void setup() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/test", (requestContext, responseCallback) -> {
            try {
                String asString = IOUtils.toString((InputStream)requestContext.getRequest().getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                responseCallback.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity(asString)), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            catch (IOException e) {
                responseCallback.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, (HttpEntity)new StringHttpEntity(e.toString())), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
        }).start();
    }

    @Test
    void sendPartialRequestShouldTimeout() throws IOException {
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.port);){
            tcpTextClient.sendString("GET /test HTTP/1.1\nHost: localhost: %s\n\n".formatted(this.port));
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.equalToCompressingWhiteSpace((String)"HTTP/1.1 200 OK\ncontent-length: 0"));
            tcpTextClient.sendString("GET /test HTTP/1.1\nHost: localhost: %d\n\n".formatted(this.port));
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.equalToCompressingWhiteSpace((String)"HTTP/1.1 200 OK\ncontent-length: 0"));
            long elapsedNanos = TestUtils.measuringNanoseconds(() -> {
                String content = tcpTextClient.receiveUntil("\r\n\r\n");
                MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)""));
            });
            long toleranceNanos = TimeUnit.MILLISECONDS.toNanos(50L);
            long connectionTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(500L);
            MatcherAssert.assertThat((Object)elapsedNanos, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(connectionTimeoutNanos + toleranceNanos))));
        }
    }
}

