/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.TimeUnit;
import org.mule.service.http.test.netty.impl.benchmark.ServerPipelineBenchmarkState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=1, jvmArgsAppend={})
public class ServerPipelineBenchmark {
    @Benchmark
    @Threads(value=1)
    @Warmup(iterations=1, time=3, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    public void readRequests(ServerPipelineBenchmarkState state) {
        try {
            state.channel.writeInbound(new Object[]{state.getRawRequest()});
            Object responseHeaderAsByteBuf = state.channel.readOutbound();
            if (responseHeaderAsByteBuf == null) {
                throw new IllegalStateException("No response read");
            }
            ReferenceCountUtil.release((Object)responseHeaderAsByteBuf);
            Object emptyBuf = state.channel.readOutbound();
            if (emptyBuf == null) {
                throw new IllegalStateException("Missing empty buffer!");
            }
            assert (emptyBuf == Unpooled.EMPTY_BUFFER);
            ReferenceCountUtil.release((Object)emptyBuf);
        }
        catch (Exception e) {
            throw new RuntimeException("Request execution failed", e);
        }
    }
}

