/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.common.server.sse;

import org.mule.runtime.http.api.server.async.ResponseStatusCallback;

import java.util.concurrent.CompletableFuture;

/**
 * Implementation of {@link ResponseStatusCallback} that delegates to a {@link CompletableFuture<Void>}.
 */
public class FutureCompleterCallback implements ResponseStatusCallback {

  private final CompletableFuture<Void> future;

  public FutureCompleterCallback(CompletableFuture<Void> future) {
    this.future = future;
  }

  @Override
  public void responseSendFailure(Throwable throwable) {
    future.completeExceptionally(throwable);
  }

  @Override
  public void responseSendSuccessfully() {
    future.complete(null);
  }

  @Override
  public void onErrorSendingResponse(Throwable throwable) {
    future.completeExceptionally(throwable);
  }
}
