/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message;

import static org.mule.runtime.http.api.HttpHeaders.Names.CONTENT_LENGTH;
import static org.mule.runtime.http.api.HttpHeaders.Names.CONTENT_TYPE;

import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.util.HttpResponseCreatorUtils;

import java.io.InputStream;

import io.netty.handler.codec.http.HttpResponse;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreator {

  private static final String HEADER_CONTENT_TYPE = CONTENT_TYPE.toLowerCase();
  private static final String HEADER_CONTENT_LENGTH = CONTENT_LENGTH.toLowerCase();

  private final HttpResponseCreatorUtils httpResponseCreatorUtils;

  public HttpResponseCreator() {
    this.httpResponseCreatorUtils = new HttpResponseCreatorUtils();
  }

  public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpResponse response, InputStream inputStream) {

    HttpResponseBuilder responseBuilder = httpResponseCreatorUtils.buildResponseHeaders(response);
    String contentType = httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
    String contentLength = httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);

    responseBuilder.entity(
                           httpResponseCreatorUtils.createEntity(inputStream, contentType, contentLength,
                                                                 response.status().code()));

    return responseBuilder.build();
  }

  public org.mule.runtime.http.api.domain.message.response.HttpResponse create(HttpClientResponse response,
                                                                               InputStream inputStream) {
    int statusCode = response.status().code();
    String contentType = httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_TYPE);
    String contentLength = httpResponseCreatorUtils.extractHeader(response, HEADER_CONTENT_LENGTH);
    HttpEntity entity = httpResponseCreatorUtils.createEntity(inputStream, contentType, contentLength, statusCode);
    return new ReactorNettyResponseWrapper(response, entity);
  }
}
