/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.server.sse;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.runtime.http.api.sse.server.SseResponseCustomizer;
import org.mule.service.http.common.server.sse.FutureCompleterCallback;

public class SseRequestContextImpl
implements SseRequestContext {
    private final HttpRequestContext requestContext;
    private final HttpResponseReadyCallback responseCallback;
    private String clientId = null;
    private boolean rejectResponseSent;
    private Consumer<SseResponseCustomizer> responseCustomizer;

    public SseRequestContextImpl(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
        this.requestContext = requestContext;
        this.responseCallback = responseCallback;
        this.rejectResponseSent = false;
        this.responseCustomizer = res -> {};
    }

    public HttpRequest getRequest() {
        return this.requestContext.getRequest();
    }

    public HttpRequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setClientId(String overrideId) {
        this.clientId = overrideId;
    }

    public CompletableFuture<Void> reject(int statusCode, String reasonPhrase) {
        HttpResponse response = ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).reasonPhrase(reasonPhrase).addHeader("Connection", "close")).build();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.rejectResponseSent = true;
        this.responseCallback.responseReady(response, (ResponseStatusCallback)new FutureCompleterCallback(future));
        return future;
    }

    public void customizeResponse(Consumer<SseResponseCustomizer> responseCustomizer) {
        this.responseCustomizer = responseCustomizer;
    }

    public Consumer<SseResponseCustomizer> getResponseCustomizer() {
        return this.responseCustomizer;
    }

    public boolean isResponded() {
        return this.rejectResponseSent;
    }

    public Optional<String> getClientId() {
        return Optional.ofNullable(this.clientId);
    }
}

