/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.tck;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;

import org.junit.rules.ExternalResource;

public class ExecutorRule extends ExternalResource {

  private TestScheduledThreadPoolExecutor executor;

  @Override
  protected void before() throws Throwable {
    executor = new TestScheduledThreadPoolExecutor(8);
  }

  @Override
  protected void after() {
    executor.shutdownNow();
  }

  public void setRejectNext() {
    executor.setRejectNext(true);
  }

  public ScheduledExecutorService getExecutor() {
    return executor;
  }

  private static class TestScheduledThreadPoolExecutor extends ScheduledThreadPoolExecutor {

    private final AtomicBoolean rejectNext = new AtomicBoolean(false);

    public TestScheduledThreadPoolExecutor(int corePoolSize) {
      super(corePoolSize);
    }

    @Override
    public void execute(Runnable command) {
      if (rejectNext.compareAndSet(true, false)) {
        throw new RejectedExecutionException();
      }
      super.execute(command);
    }

    public void setRejectNext(boolean rejectNext) {
      this.rejectNext.set(rejectNext);
    }
  }
}
