/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.client.sse;

import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.service.http.common.client.sse.ServerSentEventDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseStreamConsumer
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SseStreamConsumer.class);
    private final HttpEntity entity;
    private final ServerSentEventDecoder decoder;

    public SseStreamConsumer(HttpEntity entity, SseListener listener, String clientName) {
        this.entity = entity;
        this.decoder = new ServerSentEventDecoder(listener);
        LOGGER.trace("Creating SSE stream consumer with decoder id '{}' associated to client named '{}'", (Object)this.decoder.getId(), (Object)clientName);
    }

    @Override
    public void run() {
        InputStream content = this.entity.getContent();
        try (ServerSentEventDecoder serverSentEventDecoder = this.decoder;){
            if (this.entity.getBytesLength().isPresent()) {
                int length = (int)this.entity.getBytesLength().getAsLong();
                byte[] buffer = new byte[length];
                int actualRead = content.read(buffer);
                this.decoder.decode(buffer, actualRead);
            } else {
                byte[] buffer = new byte[8096];
                boolean eosReached = false;
                while (!eosReached) {
                    int actualRead = content.read(buffer);
                    if (actualRead == -1) {
                        eosReached = true;
                        continue;
                    }
                    this.decoder.decode(buffer, actualRead);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed while consuming SSE stream of decoder with id %d".formatted(this.decoder.getId()), e);
        }
    }
}

