/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.server;

import static org.apache.hc.core5.http.HttpStatus.SC_OK;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.DummyRequestHandler;
import org.mule.service.http.test.netty.utils.client.TestSSLNettyClient;
import org.mule.service.http.test.netty.utils.server.TestHttpServer;
import org.mule.tck.junit4.rule.DynamicPort;

import io.qameta.allure.Issue;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RehandshakeTestCase extends AbstractHttpTestCase {

  @ClassRule
  public static ExecutorRule executorRule = new ExecutorRule();

  @Rule
  public DynamicPort serverPort = new DynamicPort("serverPort");

  @Rule
  public TestHttpServer server = new TestHttpServer("localhost", serverPort.getNumber(), true);

  @Rule
  public TestSSLNettyClient testClient = new TestSSLNettyClient("localhost", serverPort.getNumber(), executorRule.getExecutor());

  @Before
  public void setUp() {
    server.addRequestHandler("/path", new DummyRequestHandler()).start();
  }

  @Test
  @Issue("W-15631497")
  public void testSSLRehandshake() throws Exception {
    String sslEndpoint = "/path";
    HttpResponse initialResponse = testClient.sendGet(sslEndpoint);
    assertThat(initialResponse.getStatusCode(), is(SC_OK));
    testClient.reHandshake();
    HttpResponse rehandshakeResponse = testClient.sendGet(sslEndpoint);
    assertThat(rehandshakeResponse.getStatusCode(), is(SC_OK));
  }
}
