/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit5.DynamicPort;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

/**
 * This test case is here to avoid functional regressions in the benchmark.
 */
class SmokeBenchmarkTestCase extends AbstractMuleTestCase {

  @DynamicPort(systemProperty = "serverPort")
  private Integer serverPort;

  private ServerPipelineBenchmarkState state;

  @BeforeEach
  void setUpState() throws Exception {
    state = new ServerPipelineBenchmarkState();
    state.port = serverPort;
    state.setUpTrial();
  }

  @AfterEach
  void tearDownState() {
    state.tearDown();
  }

  @Test
  void readRequests() {
    var benchmarkInstance = new ServerPipelineBenchmark();

    // Execute N > 1 times because the state reuses a ref-counted buffer.
    benchmarkInstance.readRequests(state);
    benchmarkInstance.readRequests(state);
    benchmarkInstance.readRequests(state);
    benchmarkInstance.readRequests(state);
  }
}
