/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;

public class MulePersistentConnectionsHandler
extends ChannelDuplexHandler {
    private final boolean usePersistentConnections;

    public MulePersistentConnectionsHandler(boolean usePersistentConnections) {
        this.usePersistentConnections = usePersistentConnections;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        HttpRequest request;
        if (msg instanceof HttpRequest && !(request = (HttpRequest)msg).headers().contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            if (this.usePersistentConnections) {
                request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            } else {
                request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
        }
        super.write(ctx, msg, promise);
    }
}

