/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.qameta.allure.Feature;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.netty.utils.TestUtils;
import org.mule.tck.junit5.DynamicPort;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.DisposableServer;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpServer;

@Feature(value="HTTP/2 Support")
class Http2ClientServerCloseNotifyTestCase
extends AbstractHttpServiceTestCase {
    private static final int CLOSE_NOTIFY_TIMEOUT_MS = 10000;
    @DynamicPort(systemProperty="serverPort")
    Integer serverPort;
    private DisposableServer httpServer;
    private HttpClient httpClient;
    private final CountDownLatch closeNotifySent = new CountDownLatch(1);

    public Http2ClientServerCloseNotifyTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        this.httpServer = this.createServer();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.stop();
        this.httpServer.disposeNow();
    }

    @Test
    void http1Only_whenCloseNotifyIsReceivedThenConnectionIsClosed() throws ExecutionException, InterruptedException, CreateException {
        this.httpClient = this.createClient(true, false);
        this.whenCloseNotifyIsReceivedThenConnectionIsClosed();
    }

    @Test
    void http2Only_whenCloseNotifyIsReceivedThenConnectionIsClosed() throws ExecutionException, InterruptedException, CreateException {
        this.httpClient = this.createClient(false, true);
        this.whenCloseNotifyIsReceivedThenConnectionIsClosed();
    }

    @Test
    void bothProtocols_whenCloseNotifyIsReceivedThenConnectionIsClosed() throws ExecutionException, InterruptedException, CreateException {
        this.httpClient = this.createClient(true, true);
        this.whenCloseNotifyIsReceivedThenConnectionIsClosed();
    }

    private void whenCloseNotifyIsReceivedThenConnectionIsClosed() throws ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("https://localhost:%d/test".formatted(this.serverPort)).build();
        this.httpClient.sendAsync(request).get();
        MatcherAssert.assertThat((String)"close notify was never sent by the server", (Object)this.closeNotifySent.await(10000L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)true));
        Thread.sleep(500L);
        this.httpClient.sendAsync(request).get();
    }

    private HttpClient createClient(boolean http1Enabled, boolean http2Enabled) throws CreateException {
        HttpClient client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("HTTP/2 Client").setHttp1Config(new Http1ProtocolConfig(http1Enabled)).setHttp2Config(new Http2ProtocolConfig(http2Enabled)).setTlsContextFactory(TlsContextFactory.builder().trustStorePath("trustStore").trustStorePassword("mulepassword").insecureTrustStore(true).build()).build());
        client.start();
        return client;
    }

    private DisposableServer createServer() throws NoSuchAlgorithmException, KeyManagementException, CreateException {
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().keyStorePath("serverKeystore").keyStorePassword("mulepassword").keyAlias("muleserver").keyPassword("mulepassword").keyStoreAlgorithm("PKIX").build();
        SslContext serverSslContext = TestUtils.createSslContext(tlsContextFactory);
        AtomicReference sslHandler = new AtomicReference();
        return ((HttpServer)((HttpServer)HttpServer.create().port(this.serverPort.intValue()).protocol(new HttpProtocol[]{HttpProtocol.HTTP11, HttpProtocol.H2}).secure(spec -> spec.sslContext(serverSslContext)).doOnChannelInit((observer, channel, remoteAddress) -> sslHandler.set((SslHandler)channel.pipeline().get(SslHandler.class)))).doOnConnection(conn -> {
            SendCloseNotifyAfterLastResponseHandler.register(conn.channel(), (SslHandler)sslHandler.get(), this.closeNotifySent);
            IgnoreCloseNotifyHandler.register(conn);
        })).handle((req, res) -> res.sendString((Publisher)Mono.just((Object)"test"))).bindNow();
    }

    private static final class SendCloseNotifyAfterLastResponseHandler
    extends ChannelOutboundHandlerAdapter {
        static final String NAME = "handler.send_close_notify_after_response";
        private final CountDownLatch latch;
        private final SslHandler sslHandler;

        SendCloseNotifyAfterLastResponseHandler(CountDownLatch latch, SslHandler sslHandler) {
            this.latch = latch;
            this.sslHandler = sslHandler;
        }

        static void register(Channel channel, SslHandler sslHandler, CountDownLatch latch) {
            SendCloseNotifyAfterLastResponseHandler handler = new SendCloseNotifyAfterLastResponseHandler(latch, sslHandler);
            channel.pipeline().addBefore("reactor.left.httpTrafficHandler", NAME, (ChannelHandler)handler);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg instanceof LastHttpContent || msg instanceof Http2DataFrame && ((Http2DataFrame)msg).isEndStream()) {
                promise.addListener(future -> this.sslHandler.closeOutbound().addListener(f -> this.latch.countDown()));
            }
            ctx.write(msg, promise);
        }
    }

    static final class IgnoreCloseNotifyHandler
    extends ChannelInboundHandlerAdapter {
        static final String NAME = "handler.ignore_close_notify";

        IgnoreCloseNotifyHandler() {
        }

        static void register(Connection cnx) {
            cnx.channel().pipeline().addBefore("reactor.right.reactiveBridge", NAME, (ChannelHandler)new IgnoreCloseNotifyHandler());
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (!(evt instanceof SslCloseCompletionEvent) || !((SslCloseCompletionEvent)evt).isSuccess()) {
                ctx.fireUserEventTriggered(evt);
            }
        }
    }
}

