/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.service;

import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.service.http.netty.impl.client.ContextHttpClientConnectionFactory;

/**
 * Implementation of {@link HttpClientFactory} that receives the contextual information in the constructor to end up delegating
 * the {@link HttpClient} creation to a {@link ContextHttpClientConnectionFactory}.
 */
public class ContextHttpClientFactory implements HttpClientFactory {

  private final ContextHttpClientConnectionFactory delegate;

  public ContextHttpClientFactory(ContextHttpClientConnectionFactory delegate) {
    this.delegate = delegate;
  }

  @Override
  public HttpClient create(HttpClientConfiguration configuration) {
    return delegate.create(configuration);
  }
}
