/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.message;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.netty.impl.message.NettyHttpRequestAdapter;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.test.common.AbstractHttpTestCase;

@Issue(value="W-15818350")
public class NettyHttpRequestAdapterQueryParamsTestCase
extends AbstractHttpTestCase {
    private final ServerAddress address = NettyHttpRequestAdapterQueryParamsTestCase.localhost80();
    private final InputStream testPayload = new ByteArrayInputStream("Hello world".getBytes());

    @Test
    public void oneKeyValueQueryParameter() {
        HttpRequest nettyRequest = this.withUri("https://test.org/path?key=value");
        org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest = this.adaptToMule(nettyRequest);
        MultiMap queryParams = muleRequest.getQueryParams();
        MatcherAssert.assertThat((Object)queryParams.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"key"), (Matcher)Matchers.contains((Object[])new String[]{"value"}));
    }

    @Test
    public void onlyKeyQueryParameter() {
        HttpRequest nettyRequest = this.withUri("https://test.org/path?key");
        org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest = this.adaptToMule(nettyRequest);
        MultiMap queryParams = muleRequest.getQueryParams();
        MatcherAssert.assertThat((Object)queryParams.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"key"), (Matcher)Matchers.contains((Matcher)Matchers.nullValue()));
    }

    @Test
    public void notExistentKeyQueryParameter() {
        HttpRequest nettyRequest = this.withUri("https://test.org/path?key");
        org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest = this.adaptToMule(nettyRequest);
        MultiMap queryParams = muleRequest.getQueryParams();
        MatcherAssert.assertThat((Object)queryParams.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"notExistent"), (Matcher)Matchers.empty());
    }

    @Test
    public void multiValueForSameKeyQueryParameter() {
        HttpRequest nettyRequest = this.withUri("https://test.org/path?key=value1&key=value2");
        org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest = this.adaptToMule(nettyRequest);
        MultiMap queryParams = muleRequest.getQueryParams();
        MatcherAssert.assertThat((Object)queryParams.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"key"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    public void combinedQueryParameterTypes() {
        HttpRequest nettyRequest = this.withUri("https://test.org/path?key1=value1_1&key1=value1_2&key2=value2&key3");
        org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest = this.adaptToMule(nettyRequest);
        MultiMap queryParams = muleRequest.getQueryParams();
        MatcherAssert.assertThat((Object)queryParams.size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"key1"), (Matcher)Matchers.contains((Object[])new String[]{"value1_1", "value1_2"}));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"key2"), (Matcher)Matchers.contains((Object[])new String[]{"value2"}));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"key3"), (Matcher)Matchers.contains((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)queryParams.getAll((Object)"key4"), (Matcher)Matchers.empty());
    }

    @Test
    public void noQueryParameters() {
        HttpRequest nettyRequest = this.withUri("https://test.org/path");
        org.mule.runtime.http.api.domain.message.request.HttpRequest muleRequest = this.adaptToMule(nettyRequest);
        MultiMap queryParams = muleRequest.getQueryParams();
        MatcherAssert.assertThat((Object)queryParams.size(), (Matcher)Matchers.is((Object)0));
    }

    HttpRequest withUri(String uri) {
        return new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri);
    }

    org.mule.runtime.http.api.domain.message.request.HttpRequest adaptToMule(HttpRequest nettyRequest) {
        return new NettyHttpRequestAdapter(nettyRequest, this.address, this.testPayload);
    }

    private static ServerAddress localhost80() {
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 80);
        return new DefaultServerAddress(address.getAddress(), address.getPort());
    }
}

