/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.service.http.netty.impl.client.ContextHttpClientConnectionFactory;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.util.SslContextHelper;

public class HttpClientConnectionManager
implements ContextHttpClientConnectionFactory,
Disposable,
Initialisable {
    private static final int CLIENT_SELECTOR_THREAD_COUNT = Integer.getInteger("mule.http.client.selectors.count", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private final SchedulerService schedulerService;
    private final Map<String, HttpClient> clients = new ConcurrentHashMap<String, HttpClient>();
    private Scheduler ioTasksScheduler;

    public HttpClientConnectionManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public HttpClient getOrCreateClient(String name, Supplier<? extends HttpClientConfiguration> configuration) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Client name can't be null");
        return this.clients.computeIfAbsent(name, serverName -> this.create((HttpClientConfiguration)configuration.get()));
    }

    @Override
    public HttpClient create(HttpClientConfiguration configuration) {
        try {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"Client configuration can't be null");
            NettyHttpClient.Builder builder = NettyHttpClient.builder().withName(configuration.getName()).withProxyConfig(configuration.getProxyConfig()).withSslContext(SslContextHelper.sslContextForClient(configuration.getTlsContextFactory(), configuration.getHttp1ProtocolConfig().isEnabled(), configuration.getHttp2ProtocolConfig().isEnabled())).withConnectionIdleTimeout(configuration.getConnectionIdleTimeout()).withUsingPersistentConnections(configuration.isUsePersistentConnections()).withSelectorsScheduler(this::createSelectorsScheduler).withSelectorsCount(CLIENT_SELECTOR_THREAD_COUNT).withMaxConnections(configuration.getMaxConnections()).withIOTasksScheduler((ScheduledExecutorService)this.ioTasksScheduler).withResponseStreamingEnabled(configuration.isStreaming()).withTcpProperties(this.getTcpProperties(configuration)).withHttp1Config(configuration.getHttp1ProtocolConfig()).withHttp2Config(configuration.getHttp2ProtocolConfig()).withDecompressionEnabled(configuration.isDecompress());
            return this.enrichClientBuilder(builder, configuration).build();
        }
        catch (IllegalArgumentException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private TcpClientSocketProperties getTcpProperties(HttpClientConfiguration configuration) {
        TcpClientSocketProperties configProperties = configuration.getClientSocketProperties();
        if (configProperties != null) {
            return configProperties;
        }
        return TcpClientSocketProperties.builder().build();
    }

    private Scheduler createSelectorsScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.customScheduler(SchedulerConfig.config().withDirectRunCpuLightWhenTargetBusy(true).withMaxConcurrentTasks(CLIENT_SELECTOR_THREAD_COUNT).withName("http.requester"), CLIENT_SELECTOR_THREAD_COUNT);
    }

    private Scheduler getIOSchedulerIfPossible() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.ioScheduler();
    }

    protected NettyHttpClient.Builder enrichClientBuilder(NettyHttpClient.Builder builder, HttpClientConfiguration configuration) {
        return builder;
    }

    public void dispose() {
        if (this.ioTasksScheduler != null) {
            this.ioTasksScheduler.shutdown();
            this.ioTasksScheduler = null;
        }
    }

    public void initialise() throws InitialisationException {
        this.ioTasksScheduler = this.getIOSchedulerIfPossible();
    }
}

