/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.http.HttpResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;

public class SlowResponsesWithRecursionTestCase
extends AbstractHttpServerTestCase {
    private static final long SOME_TIME = 100L;
    private static final int REQUESTS = 20;
    private static final int LATCH_TIMEOUT = 5000;
    private static final String ENDPOINT = "/recursiveCalls";
    private final CountDownLatch started = new CountDownLatch(20);
    private final CountDownLatch finished = new CountDownLatch(20);
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public SlowResponsesWithRecursionTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected void setUpServer() throws Exception {
        this.server = this.service.getServerFactory().create(this.configureServer(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.intValue()).setName(this.getServerName()).setSchedulerSupplier(() -> this.getSchedulerService().ioScheduler())).build());
        this.server.start();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.setUpServer();
        this.registerHandler();
    }

    private void registerHandler() {
        this.server.addRequestHandler(Collections.singletonList(HttpConstants.Method.POST.name()), ENDPOINT, (requestContext, responseCallback) -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try {
                int message = Integer.parseInt(new String(requestContext.getRequest().getEntity().getBytes()));
                this.respondInAnotherThread(message, responseCallback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    @Override
    protected String getServerName() {
        return "sarasa";
    }

    @Test
    void test() throws Exception {
        AtomicInteger correctCount = new AtomicInteger(0);
        for (int i = 0; i < 20; ++i) {
            this.performRequestInThread(correctCount);
        }
        this.started.await();
        if (!this.finished.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)String.format("We only got %d responses out of %d", correctCount.get(), 20));
        }
    }

    private void performRequestInThread(AtomicInteger counter) {
        this.executor.submit(() -> {
            try {
                this.started.countDown();
                Request request = Request.post((String)this.urlForPath(ENDPOINT));
                request.bodyByteArray("2".getBytes());
                HttpResponse response = request.execute().returnResponse();
                MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
                counter.incrementAndGet();
                this.finished.countDown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void respondInAnotherThread(int message, HttpResponseReadyCallback responseCallback) {
        this.executor.submit(() -> {
            try {
                if (message > 0) {
                    Request request = Request.post((String)this.urlForPath(ENDPOINT));
                    request.bodyByteArray(Integer.toString(message - 1).getBytes());
                    HttpResponse response = request.execute().returnResponse();
                    MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
                }
            }
            catch (IOException request) {
                // empty catch block
            }
            InputStream slow = new InputStream(){
                private int count = 0;

                @Override
                public int read() throws IOException {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    return this.count++ <= 100 ? 1 : -1;
                }
            };
            responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(slow))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
        });
    }
}

