/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Story;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.proxy.ProxyConfigBuilder;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.client.AbstractHttpClientTestCase;
import org.mule.tck.http.TestProxyServer;
import org.mule.tck.junit5.DynamicPort;

@Story(value="Proxies")
public class HttpClientProxyTestCase
extends AbstractHttpClientTestCase {
    private static final String GLOBAL_RESPONSE = "Global proxy used";
    private static final String REQUEST_RESPONSE = "Request proxy used";
    @DynamicPort(systemProperty="globalProxyPort")
    Integer globalProxyPort;
    @DynamicPort(systemProperty="requestProxyPort")
    Integer requestProxyPort;
    @DynamicPort(systemProperty="serverPort")
    Integer serverPort;
    private TestProxyServer globalProxy;
    private TestProxyServer requestProxy;
    private HttpClient client;
    private HttpServer requestServer;

    public HttpClientProxyTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(GLOBAL_RESPONSE.getBytes()))).build();
    }

    @BeforeEach
    public void createClient() throws Exception {
        this.globalProxy = new TestProxyServer(this.globalProxyPort.intValue(), this.port.intValue(), false);
        this.requestProxy = new TestProxyServer(this.requestProxyPort.intValue(), this.serverPort.intValue(), false);
        this.requestServer = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.serverPort.intValue()).setName("proxy-test-server").build());
        this.requestServer.start();
        this.requestServer.addRequestHandler("/*", (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity(REQUEST_RESPONSE.getBytes()))).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
        this.globalProxy.start();
        this.requestProxy.start();
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("proxy-test").setProxyConfig(((ProxyConfigBuilder)((ProxyConfigBuilder)ProxyConfig.builder().host("localhost")).port(this.globalProxyPort.intValue())).build()).build());
        this.client.start();
    }

    @AfterEach
    public void stopClient() throws Exception {
        if (this.requestServer != null) {
            this.requestServer.stop();
        }
        if (this.requestProxy != null) {
            this.requestProxy.stop();
        }
        if (this.globalProxy != null) {
            this.globalProxy.stop();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    void usesDefaultProxy() throws Exception {
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.getUri()).build(), this.getDefaultOptions(10000));
        MatcherAssert.assertThat((Object)this.globalProxy.hasConnections(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.requestProxy.hasConnections(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)GLOBAL_RESPONSE));
    }

    @Test
    void overridesDefaultProxy() throws Exception {
        HttpResponse response = this.client.send(HttpRequest.builder().uri("http://localhost:" + this.serverPort).build(), HttpRequestOptions.builder().responseTimeout(10000).proxyConfig(((ProxyConfigBuilder)((ProxyConfigBuilder)ProxyConfig.builder().host("localhost")).port(this.requestProxyPort.intValue())).build()).build());
        MatcherAssert.assertThat((Object)this.globalProxy.hasConnections(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.requestProxy.hasConnections(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)REQUEST_RESPONSE));
    }
}

